<table id="myTable" class="dataTable table table-hover display responsive nowrap">
    <thead>
        <tr>

            <th>
                <span class="sortable" data-sort="full_name" data-order="asc">
                    Name
                    <i id="sort-icon-full_name" class="bx bx-sort"></i>
                </span>
            </th>
            <th>
                <span class="sortable" data-sort="email" data-order="asc">
                    Email
                    <i id="sort-icon-email" class="bx bx-sort"></i>
                </span>
            </th>
            <th>
                <span class="sortable" data-sort="mobile_number" data-order="asc">
                    Mobile
                    <i id="sort-icon-mobile_number" class="bx bx-sort"></i>
                </span>
            </th>
            <th>
                <span class="sortable" data-sort="wholesale_plan_id" data-order="asc">
                    Wholesale ID
                    
                </span>
            </th>

            <th>
                <span class="sortable" data-sort="status" data-order="asc">
                    Status
                    <i id="sort-icon-status" class="bx bx-sort"></i>
                </span>
            </th>
            <th>
                <span class="sortable" data-sort="created_at" data-order="asc">
                    Created at
                    <i id="sort-icon-created_at" class="bx bx-sort"></i>
                </span>

            </th>
            <th>Actions</th>
        </tr>
    </thead>
    <?php if(isset($customers) && count($customers) > 0): ?>
        <tbody class="table-border-bottom-0">

            <?php $__currentLoopData = $customers; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $customer): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <tr>

                    <td class="text-capitalize"><?php echo e($customer->full_name); ?></td>
                    <td><?php echo e($customer->email); ?></td>
                    <td><?php echo e($customer->dial_code); ?><?php echo e($customer->mobile_number); ?></td>
                    <td>
                        <div>
                            <span class="<?php echo e($customer->activePlanWholesale ? 'text-success' : 'text-danger'); ?>">
                                <?php echo e($customer->activePlanWholesale ? 'Yes' : 'N/A'); ?>

                            </span>

                        </div>
                        <?php echo e($customer->activePlanWholesale ? $customer->activePlanWholesale->custom_plan_id : ''); ?>

                    </td>
                    <td>
                        <span class="badge <?php echo e(badgesforStatuses($customer->status)); ?>">
                            <?php echo e(basicStatusesDisplay($customer->status)); ?>

                        </span>
                    </td>
                    <td><?php echo e(dateInList($customer->created_at)); ?></td>
                    
                    <td class="<?php echo e(hideAction($customer->status)); ?>">
                        <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->any(['list-customer', 'delete-customer', 'edit-customer'])): ?>
                            <div class="dropdown">
                                <button type="button" class="btn p-0 dropdown-toggle hide-arrow" data-bs-toggle="dropdown">
                                    <i class="bx bx-dots-vertical-rounded"></i>
                                </button>
                                <div class="dropdown-menu">
                                    <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check(['list-customer'])): ?>
                                        <a class="dropdown-item"
                                            href="<?php echo e(url('admin/orders?customer_id=' . $customer->id)); ?>"><i
                                                class="bx bx-show me-1"></i> View Orders</a>
                                    <?php endif; ?>
                                    <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('edit-customer')): ?>
                                        <a class="dropdown-item" href="<?php echo e(route('admin.customer.edit', $customer->id)); ?>"><i
                                                class="bx bx-edit-alt me-1"></i> Edit</a>
                                    <?php endif; ?>
                                    <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('delete-customer')): ?>
                                        <button data-url="<?php echo e(route('admin.customer.destroy', $customer->id)); ?>"
                                            data-id="<?php echo e($customer->id); ?>" type="button" class="dropdown-item delete-btn"
                                            href="javascript:void(0);"><i class="bx bx-trash me-1"></i>
                                            Delete</button>
                                    <?php endif; ?>
                                </div>
                            </div>
                        <?php endif; ?>
                    </td>
                </tr>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </tbody>

        <tfoot>
            <tr>
                <td class="" colspan="6">
                    <div class="mt-2 row justify-space-between mb-2">
                        <div class="col-md-6">
                            <div class="" id="records"><?php echo pageInfo($customers); ?></div>
                        </div>
                        <div class="col-md-6 pagination-end">

                            <?php echo $customers->links('pagination::bootstrap-4'); ?>


                        </div>
                    </div>
                </td>
            </tr>
        </tfoot>
    <?php endif; ?>
</table>
<?php /**PATH F:\xampp\htdocs\aaa\resources\views/admin/customer/pagination.blade.php ENDPATH**/ ?>