<table id="myTable" class="dataTable table table-hover display responsive nowrap">
    <thead>
        <tr>

            <th style="width: 50px;">
                <span class="sortable" data-sort="order_number" data-order="asc">
                    Order Number
                    <i id="sort-icon-order_number" class="bx bx-sort"></i>
                </span>
            </th>
            <th>
                <span class="sortable" data-sort="customer_name" data-order="asc">
                    Customer Name
                    <i id="sort-icon-customer_name" class="bx bx-sort"></i>
                </span>
            </th>
            <th>
                <span class="sortable" data-sort="total_price" data-order="asc">
                    Total Amount
                    <i id="sort-icon-total_price" class="bx bx-sort"></i>
                </span>
            </th>

            <th>
                <span class="sortable" data-sort="order_status" data-order="asc">
                    Order Status
                    <i id="sort-icon-order_status" class="bx bx-sort"></i>
                </span>
            </th>
            <th>
                <span class="sortable" data-sort="total_items" data-order="asc">
                    Total Items
                    <i id="sort-icon-total_items" class="bx bx-sort"></i>
                </span>
            </th>
            <th>
                <span class="sortable" data-sort="created_at" data-order="asc">
                    Created at
                    <i id="sort-icon-created_at" class="bx bx-sort"></i>
                </span>

            </th>
            <th>Actions</th>
        </tr>
    </thead>
    <?php if(isset($orders) && count($orders) > 0): ?>
        <tbody class="table-border-bottom-0">

            <?php $__currentLoopData = $orders; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $order): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <tr>

                    <td class=""><?php echo e($order->order_number); ?></td>
                    <td class="text-capitalize"><?php echo e($order->customer?->full_name); ?></td>
                    <td class="text-capitalize">
                        <?php echo e(App\Helpers\CommonHelper::getCurrencyInfo($order->currency_code)->currency_symbol ?? ''); ?>

                        <?php echo e($order->total_price); ?>

                        <?php echo e($order->currency_code); ?>


                    </td>

                    <td class="text-capitalize">
                        <span class="badge <?php echo e(App\Helpers\CommonHelper::badgeForOrderStatuses($order->order_status)); ?>">
                            <?php echo e(orderStatuses($order->order_status)); ?>

                        </span>
                    </td>
                    <td class="">

                        <?php echo e($order->total_items); ?>


                    </td>
                    <td><?php echo e(\App\Helpers\CommonHelper::formatDate($order->created_at, $order->customer?->timezone)); ?>

                    </td>
                    <td>
                        <?php if (\Illuminate\Support\Facades\Blade::check('canViewOrderDetail', $order)): ?>
                        <a class="btn btn-success" href="<?php echo e(route('admin.orders.show', $order->id)); ?>">View</a>
                        <?php endif; ?>
                        
                    </td>

                </tr>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </tbody>

        <tfoot>
            <tr>
                <td class="" colspan="6">
                    <div class="mt-2 row justify-space-between mb-2">
                        <div class="col-md-6">
                            <div class="" id="records"><?php echo pageInfo($orders); ?></div>
                        </div>
                        <div class="col-md-6 pagination-end">

                            <?php echo $orders->links('pagination::bootstrap-4'); ?>


                        </div>
                    </div>
                </td>
            </tr>
        </tfoot>
    <?php endif; ?>
</table>
<?php /**PATH /home/intellisensetech/public_html/aaa/resources/views/admin/order/pagination.blade.php ENDPATH**/ ?>