<?php $__env->startSection('title', 'Edit Product'); ?>
<?php $__env->startSection('content'); ?>
    <!-- Content -->

    <div class="container-xxl flex-grow-1 container-p-y">
        

        <!-- Basic Layout & Basic with Icons -->
        <div class="row ">
            <!-- Basic Layout -->
            <div class="col-sm-12">
                <div class="card px-4 mb-4">
                    <div class="title-n-btn ">
                        <h4 class="">Edit Product</h4>

                    </div>

                    <div class="card-body px-0">
                        <form class="ajax-submit-form" data-url="<?php echo e(route('admin.product.update', $product->id)); ?>"
                            data-method="POST" enctype="multipart/form-data">
                            <?php echo method_field('PUT'); ?>

                            <div class="row mb-3">
                                <label class="col-sm-2 col-form-label" for="basic-default-name">Name</label>
                                <div class="col-sm-10">
                                    <input name="name" type="text" class="form-control" id="basic-default-name"
                                        value="<?php echo e(old('name', $product->name)); ?>" />

                                </div>
                            </div>
                            <div class="row mb-3">
                                <label class="col-sm-2 col-form-label" for="vehicle_model">Vehicle Models</label>

                                <div class="col-sm-10">
                                    <select class="select2 text-capitalize" name="vehicle_model[]" id="vehicle_model"
                                        multiple="multiple">
                                        <?php $__currentLoopData = $vehicleModels; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $vehicleModel): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <option class="text-capitalize" value="<?php echo e($vehicleModel->id); ?>"
                                                <?php echo e(in_array($vehicleModel->id, $product->compatibleModels->pluck('id')->toArray()) ? 'selected' : ''); ?>>
                                                Type: <?php echo e($vehicleModel->vehicleType->name ?? 'N/A'); ?>

                                                &nbsp;&nbsp;>>&nbsp;&nbsp;
                                                Make: <?php echo e($vehicleModel->vehicleMake->name ?? 'N/A'); ?>

                                                &nbsp;&nbsp;>>&nbsp;&nbsp;
                                                Model: <?php echo e($vehicleModel->name); ?>

                                            </option>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>


                                    </select>


                                </div>
                            </div>
                            
                            <div class="row mb-3">
                                <label class="col-sm-2 col-form-label" for="price">Price</label>
                                <div class="col-sm-3">
                                    
                                    <div class="input-group">
                                        <span class="input-group-text" id="basic-addon13">USD</span>
                                        <input type="number" step="0.01" min="0" name="price_in_usd"
                                            id="price_in_usd" class="form-control" placeholder="" aria-label="price_in_usd"
                                            aria-describedby="basic-addon13"
                                            value="<?php echo e(old('price_in_usd', $product->price_in_usd)); ?>" />

                                    </div>
                                </div>
                                <div class="col-sm-3">
                                    <div class="input-group">
                                        <span class="input-group-text" id="basic-addon13">MMK</span>
                                        <input type="number" step="0.01" min="0" name="price_in_mmk"
                                            id="price_in_mmk" class="form-control" placeholder="" aria-label="price_in_mmk"
                                            aria-describedby="basic-addon13"
                                            value="<?php echo e(old('price_in_mmk', $product->price_in_mmk)); ?>" />

                                    </div>
                                </div>
                                <div class="col-sm-3">
                                    <div class="input-group">
                                        <span class="input-group-text" id="basic-addon13">RMB</span>
                                        <input type="number" step="0.01" min="0" name="price_in_rmb"
                                            id="price_in_rmb" class="form-control" placeholder="" aria-label="price_in_rmb"
                                            aria-describedby="basic-addon13"
                                            value="<?php echo e(old('price_in_rmb', $product->price_in_rmb)); ?>" />

                                    </div>
                                </div>

                            </div>
                            <div class="row mb-3">
                                <label class="col-sm-2 col-form-label" for="images">Inventory</label>
                                <div class="col-sm-10">
                                    <div class="d-flex">
                                        <p class="padding-right-10"><?php echo e($product->stock_in_hand); ?></p>
                                        <a class="text-link"
                                            href="<?php echo e(route('admin.product.manageInventory', $product->id)); ?>">Manage
                                            Inventory</a>
                                    </div>


                                </div>
                            </div>
                            <div class="row mb-3">
                                <label class="col-sm-2 col-form-label" for="images">Featured Image</label>
                                <div class="col-sm-10">
                                    
                                    <input type="file" name="feature_image" class="form-control" id="feature_image">
                                    <?php if($product->featuredImage): ?>
                                        <div class="old-image">
                                            <h6 class="pt-3">Current Featured Image</h6>
                                            <div class="row">


                                                <div class="col-lg-3 col-md-6 col-sm-12 pb-3">

                                                    <img width="200" src="<?php echo e(asset($product->featuredImage->image)); ?>"
                                                        alt="" class="h-200 ">


                                                </div>


                                            </div>


                                        </div>
                                    <?php endif; ?>

                                </div>
                            </div>

                            <div class="row mb-3">
                                <label class="col-sm-2 col-form-label" for="description">Description</label>
                                <div class="col-sm-10">
                                    <textarea name="description" id="description" class="form-control " cols="30" rows="10"> <?php echo e(old('description', $product->description)); ?></textarea>
                                </div>
                            </div>

                            <div class="row mb-3">
                                <label class="col-sm-2 col-form-label" for="status">Status</label>
                                <div class="col-sm-10">
                                    <select class="select2" name="status" id="status">
                                        <?php $__currentLoopData = CommonStatusesForCrud(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $value): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <option <?php echo e(old('status', $product->status) == $key ? 'selected' : ''); ?>

                                                value="<?php echo e($key); ?>"><?php echo e($value); ?></option>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>


                                    </select>

                                </div>
                            </div>
                            <div class="row mb-3">
                                <label class="col-sm-2 col-form-label" for="images">Gallery</label>
                                <div class="col-sm-10">
                                    
                                    
                                    <div id="gallery-dropzone" class="dropzone border rounded p-3"></div>
                                    <p id="images-error" class="invalid-feedback d-block text-danger"></p>
                                </div>
                            </div>

                            <div class="row justify-content-end">
                                <div class="col-sm-10">
                                    <div class="form-check">
                                        <input class="form-check-input" type="checkbox"
                                            <?php echo e(old('is_featured', $product->is_featured ?? false) ? 'checked' : ''); ?>

                                            value="" id="is_featured" name="is_featured">
                                        <label class="form-check-label" for="is_featured">
                                            Set as Featured Product
                                        </label>
                                    </div>
                                </div>
                            </div>

                            <div class="row justify-content-end pt-3">
                                <div class="col-sm-10">
                                    <button type="submit" class="btn btn-primary">Update</button>
                                </div>
                            </div>
                        </form>
                    </div>
                </div>
            </div>

        </div>
    </div>

    <!-- / Content -->
<?php $__env->stopSection(); ?>
<?php
    $existingImages = $product->images->map(function ($g) {
        $size = null;
        $path = public_path($g->image);
        if (file_exists($path)) {
            $size = filesize($path);
        }
        return [
            'id' => $g->id,
            'image' => $g->image,
            'url' => asset($g->image),
            'size' => $size,
        ];
    });
?>
<?php $__env->startSection('scripts'); ?>
    <script>
        $(document).on('click', '.delete-image', function() {
            let imageId = $(this).data('id');
            let url = $(this).data('url');
            let button = $(this);

            Swal.fire({
                title: 'Are you sure?',
                text: "You want to delete this image?",
                icon: 'warning',
                showCancelButton: true,
                confirmButtonColor: '#d33',
                confirmButtonText: 'Yes, delete it!'
            }).then((result) => {
                if (result.isConfirmed) {
                    $.ajax({
                        url: url,
                        type: 'DELETE',

                        success: function(res) {
                            button.closest('.image-container').remove();
                            Swal.fire({
                                title: 'Deleted!',
                                text: 'Image has been deleted.',
                                icon: 'success'
                            }).then((result) => {

                                // if (result.isConfirmed || result.isDismissed) {
                                //     location
                                //         .reload();
                                // }
                            });
                        },
                        error: function() {
                            Swal.fire('Error!', 'Something went wrong.', 'error');
                        }
                    });
                }
            });
        });


        const usdToMmkRate = <?php echo e($currrncyRateMmk ?? 0); ?>

        const usdToRmbRate = <?php echo e($currrncyRateRmb ?? 0); ?>

        // When typing in USD field
        $('#price_in_usd').on('input', function() {
            let usd = parseFloat($(this).val());
            if (!isNaN(usd)) {
                let mmk = (usd * usdToMmkRate).toFixed(2);
                let rmb = (usd * usdToRmbRate).toFixed(2);
                $('#price_in_mmk').val(mmk);
                $('#price_in_rmb').val(rmb);
            } else {
                $('#price_in_mmk').val('');
                $('#price_in_rmb').val('');
            }
        });

        // When typing in MMK field
        $('#price_in_mmk').on('input', function() {
            let mmk = parseFloat($(this).val());
            if (!isNaN(mmk)) {

                let usd = (mmk / usdToMmkRate).toFixed(2);
                $('#price_in_usd').val(usd);
                let rmb = (usd * usdToRmbRate).toFixed(2);

                $('#price_in_rmb').val(rmb);
            } else {
                $('#price_in_usd').val('');
                $('#price_in_rmb').val('');
            }
        });
        // When typing in RMB field
        $('#price_in_rmb').on('input', function() {
            let rmb = parseFloat($(this).val());
            let mmk = parseFloat($('#price_in_mmk').val());
            if (!isNaN(rmb)) {
                let usd = (rmb / usdToRmbRate).toFixed(2);
                $('#price_in_usd').val(usd);
                let mmk = (usd * usdToMmkRate).toFixed(2);
                $('#price_in_mmk').val(mmk);
            } else {
                $('#price_in_usd').val('');
                $('#price_in_mmk').val('');

            }
        });
        //send product's images to JS globbally
        window.existingImages = <?php echo json_encode($existingImages, 15, 512) ?>;
    </script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('admin.layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/intellisensetech/public_html/aaa/resources/views/admin/product/edit.blade.php ENDPATH**/ ?>