
<?php $__env->startSection('title', 'Create Banner'); ?>
<?php $__env->startSection('content'); ?>
    <div class="content-wrapper">
        <!-- Content -->
        <div class="container">


            <div class="row mt-4">
                <div class="col-lg-12">
                    <div class="card">
                        <h5 class="card-header text-uppercase text-dark border-bottom">
                            Create Banner
                        </h5>

                        <div class="card-body">
                            <?php if($errors->any()): ?>
                                <div class="alert alert-danger">
                                    <ul>
                                        <?php $__currentLoopData = $errors->all(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $error): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <li><?php echo e($error); ?></li>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    </ul>
                                </div>
                            <?php endif; ?>
                            <div class="row mt-4">
                                <div class="col-lg-12">
                                    <form class="ajax-submit-form" data-url="<?php echo e(route('admin.banner.store')); ?>"
                                        data-method="POST" enctype="multipart/form-data">


                                        <div class="row mb-3 justify-content-end ">


                                            <div class="col-12">
                                                <div class="row my-3">
                                                    <label for="image" class="col-md-2 text-sm-end col-form-label">
                                                        Image / Video
                                                    </label>
                                                    <div class="col-md-10">
                                                        <input type="file" class="form-control " name="file"
                                                            id="file">


                                                    </div>
                                                </div>

                                                <div class="row my-3">
                                                    <label for="status"
                                                        class="col-md-2 text-sm-end col-form-label">Status</label>
                                                    <div class="col-md-10">
                                                        <select class="form-select" name="status" id="status">
                                                            <?php $__currentLoopData = CommonStatusesForCrud(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $value): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                                <option value="<?php echo e($key); ?>"><?php echo e($value); ?>

                                                                </option>
                                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

                                                        </select>
                                                        <input type="hidden" name="video_poster" id="video_poster"
                                                            class="video_poster">
                                                    </div>
                                                </div>

                                                
                                                <div class="row my-3">
                                                    <label for="image" class="col-md-2 text-sm-end col-form-label">
                                                        Sort Order
                                                    </label>
                                                    <div class="col-md-10">
                                                        <select class="form-select" name="sort_order" id="sort_order">
                                                            <?php for($i = 1; $i <= $maxSortCount; $i++): ?>
                                                                <?php
                                                                    $isDisabled = in_array($i, $usedSortOrders);
                                                                ?>
                                                                <option value="<?php echo e($i); ?>"
                                                                    <?php echo e($isDisabled ? 'disabled' : ''); ?>>
                                                                    <?php echo e($i); ?>

                                                                    <?php echo e($isDisabled ? '(used)' : ''); ?>

                                                                </option>
                                                            <?php endfor; ?>
                                                        </select>
                                                    </div>
                                                </div>

                                            </div>
                                        </div>


                                        <div class=" offset-md-2">
                                            <button type="submit" class="btn btn-primary">
                                                <i class="bx bx-check"></i> Save
                                            </button>
                                        </div>
                                </div>

                                </form>

                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <!-- / Content -->
        </div>
    <?php $__env->stopSection(); ?>
    <?php $__env->startSection('scripts'); ?>
        <script>
            document.addEventListener("DOMContentLoaded", function() {
                const fileInput = document.getElementById("file"); // your input[type=file]
                const video = document.createElement("video");
                video.style.display = "none";
                document.body.appendChild(video);

                const hiddenPosterInput = document.getElementById("video_poster");

                fileInput.addEventListener("change", function() {
                    const file = fileInput.files[0];
                    if (!file) return;

                    const fileExtension = file.name.split('.').pop().toLowerCase();
                    const videoExtensions = ['mp4', 'mov', 'avi', 'mkv', 'webm', '3gp', 'flv', 'wmv'];

                    if (videoExtensions.includes(fileExtension)) {
                        const videoURL = URL.createObjectURL(file);
                        video.src = videoURL;

                        video.onloadeddata = () => {
                            video.currentTime = 1;
                        };

                        video.onseeked = () => {
                            const canvas = document.createElement("canvas");
                            canvas.width = video.videoWidth;
                            canvas.height = video.videoHeight;

                            const ctx = canvas.getContext("2d");
                            ctx.drawImage(video, 0, 0, canvas.width, canvas.height);

                            const base64Image = canvas.toDataURL("image/jpeg", 0.8); // 80% quality
                            hiddenPosterInput.value = base64Image;
                        };
                    } else {
                        hiddenPosterInput.value = ''; // Clear if not video
                    }
                });
            });
        </script>
    <?php $__env->stopSection(); ?>

<?php echo $__env->make('admin.layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/intellisensetech/public_html/aaa/resources/views/admin/banner/create.blade.php ENDPATH**/ ?>