<table id="myTable" class="dataTable table table-hover display responsive nowrap">
    <thead>
        <tr>

            <th>
                <span class="sortable" data-sort="name" data-order="asc">
                    Name
                    <i id="sort-icon-name" class="bx bx-sort"></i>
                </span>
            </th>
            <th>
                <span class="sortable" data-sort="price_in_usd" data-order="asc">
                    Price in USD
                    <i id="sort-icon-price_in_usd" class="bx bx-sort"></i>
                </span>
            </th>
            <th>
                <span class="sortable" data-sort="price_in_mmk" data-order="asc">
                    Price in MMK
                    <i id="sort-icon-price_in_mmk" class="bx bx-sort"></i>
                </span>
            </th>
            <th>
                <span class="sortable" data-sort="status" data-order="asc">
                    Status
                    <i id="sort-icon-status" class="bx bx-sort"></i>
                </span>
            </th>
            <th>
                <span class="sortable" data-sort="created_at" data-order="asc">
                    Created at
                    <i id="sort-icon-created_at" class="bx bx-sort"></i>
                </span>

            </th>
            <th>Featured</th>
            <th>Actions</th>
        </tr>
    </thead>
    <?php if(isset($products) && count($products) > 0): ?>
        <tbody class="table-border-bottom-0">

            <?php $__currentLoopData = $products; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $product): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <tr>

                    <td class="text-capitalize"><?php echo e($product->name); ?></td>
                    <td class=""><?php echo e($product->price_in_usd); ?></td>
                    <td class=""><?php echo e($product->price_in_mmk); ?></td>
                    <td>
                        <span class="badge <?php echo e(badgesforStatuses($product->status)); ?>">
                            <?php echo e(basicStatusesDisplay($product->status)); ?>

                        </span>
                    </td>
                    <td><?php echo e(dateInList($product->created_at)); ?></td>
                    <td>
                        <?php if((int) $product->is_featured === 1): ?>
                            <span class="badge bg-warning text-dark">Featured
                                <i class="fas fa-star"></i>
                            </span>
                        <?php else: ?>
                            <span class="text-muted">--No</span>
                        <?php endif; ?>

                    </td>
                    
                    <td class="<?php echo e(hideAction($product->status)); ?>">
                        <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->any(['delete-product', 'edit-product', 'show-product'])): ?>
                            <div class="dropdown">
                                <button type="button" class="btn p-0 dropdown-toggle hide-arrow" data-bs-toggle="dropdown">
                                    <i class="bx bx-dots-vertical-rounded"></i>
                                </button>
                                <div class="dropdown-menu">

                                    <a href="<?php echo e(route('admin.product.manageInventory', $product->id)); ?>"
                                        class="dropdown-item">
                                        <i class="fa fa-clipboard-list me-1"></i>
                                        Manage Inventory
                                    </a>

                                    <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('show-product')): ?>
                                        <a class="dropdown-item" href="<?php echo e(route('admin.product.show', $product->id)); ?>">
                                            <i class="bx bx-show me-1"></i> Show</a>
                                    <?php endif; ?>
                                    <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('edit-product')): ?>
                                        <a class="dropdown-item" href="<?php echo e(route('admin.product.edit', $product->id)); ?>"><i
                                                class="bx bx-edit-alt me-1"></i> Edit</a>
                                    <?php endif; ?>
                                    <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('delete-product')): ?>
                                        <button data-url="<?php echo e(route('admin.product.destroy', $product->id)); ?>"
                                            data-id="<?php echo e($product->id); ?>" type="button" class="dropdown-item delete-btn"
                                            href="javascript:void(0);"><i class="bx bx-trash me-1"></i>
                                            Delete</button>
                                    <?php endif; ?>
                                </div>
                            </div>
                        <?php endif; ?>
                    </td>
                </tr>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </tbody>
        <tfoot>
            <tr>
                <td class="" colspan="6">
                    <div class="mt-2 row justify-space-between mb-2">
                        <div class="col-md-6">
                            <div class="" id="records"><?php echo pageInfo($products); ?></div>
                        </div>
                        <div class="col-md-6 pagination-end">

                            <?php echo $products->links('pagination::bootstrap-4'); ?>


                        </div>
                    </div>
                </td>
            </tr>
        </tfoot>

    <?php endif; ?>
</table>
<?php /**PATH /home/intellisensetech/public_html/aaa/resources/views/admin/product/pagination.blade.php ENDPATH**/ ?>