
<?php $__env->startSection('title', 'Edit Roles'); ?>
<?php $__env->startSection('content'); ?>
    <div class="content-wrapper">
        <!-- Content -->
        <div class="row m-3">
            <div class="col-lg-12">
                <div class="card">


                    <div class="card-body">
                        <div class="mt-2 d-flex justify-content-between align-items-center pb-2">
                            <h3 class=" text-dark">Edit Role</h3>

                        </div>
                        <div class="row mt-4">
                            <div class="col-lg-12">
                                <form class="ajax-submit-form" data-url="<?php echo e(route('admin.role.update', $role->id)); ?>"
                                    data-method="POST" enctype="multipart/form-data">
                                    <?php echo method_field('PUT'); ?>
                                    <input type="hidden" name="_method" value="PUT">
                                    <div class="row mb-3 justify-content-end ">
                                        <div class="col-md-2  mt-1">
                                            <label for="" class="form-label">Select Department</label>
                                        </div>

                                        <div class="col-md-10">
                                            <select name="department_id" id="department_id" class="form-select">
                                                <option value="">Select Department</option>
                                                <?php $__currentLoopData = $departments; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $department): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                    <option value="<?php echo e($department->id); ?>"
                                                        <?php echo e(old('department_id', $role->department->id ?? '') == $department->id ? 'selected' : ''); ?>>
                                                        <?php echo e(ucfirst($department->name)); ?>

                                                    </option>
                                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                            </select>


                                        </div>
                                    </div>
                                    <div class="row mb-3 justify-content-end ">
                                        <div class="col-md-2  mt-1">
                                            <label for="" class="form-label">Role Name</label>
                                        </div>

                                        <div class="col-md-10">

                                            <input class="form-control " type="text" name="name"
                                                value="<?php echo e(old('name', $role->name)); ?>" id="name">

                                        </div>
                                    </div>




                                    
                                    <div class="container">
                                        <h6 class="txt-blck">Permissions</h6>
                                        <hr>
                                        <div class="row mt-2" id="permissions">
                                            <?php if(!empty($permissions)): ?>
                                                <?php
                                                    $defaultPermissions = config(
                                                        "role_defaults.{$role->department->id}",
                                                    );
                                                ?>
                                                <?php $__currentLoopData = $permissions; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $module => $modulePermissions): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                    <div class="col-2 mt-4 ">
                                                        <label
                                                            class="text-dark text-capitalize me-3"><?php echo e($module); ?>:</label>
                                                    </div>
                                                    <div class="row">
                                                        <?php $__currentLoopData = $modulePermissions; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $permission): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                            <div class="col-3 pt-2">
                                                                <input class="form-check-input" type="checkbox"
                                                                    name="permissions[]" value="<?php echo e($permission->name); ?>"
                                                                    id="perm_<?php echo e($permission->id); ?>"
                                                                    <?php echo e(in_array($permission->name, $defaultPermissions ?? []) || $hasPermissions->contains($permission->name) ? 'checked' : ''); ?>

                                                                    <?php echo e(in_array($permission->name, $defaultPermissions ?? []) ? 'disabled' : ''); ?>>
                                                                <label class="form-check-label text-capitalize"
                                                                    for="perm_<?php echo e($permission->id); ?>">
                                                                    <?php echo e($permission->name); ?>

                                                                </label>
                                                                
                                                                <?php if(in_array($permission->name, $defaultPermissions ?? [])): ?>
                                                                    <input type="hidden" name="permissions[]"
                                                                        value="<?php echo e($permission->name); ?>">
                                                                <?php endif; ?>
                                                            </div>
                                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

                                                    </div>
                                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                            <?php endif; ?>
                                        </div>
                                    </div>


                                    <div class="row mt-4 mb-2">
                                        <div class="">
                                            <button type="submit" class="btn btn-primary">
                                                <i class="bx bx-check"></i> Update
                                            </button>
                                        </div>
                                    </div>

                                </form>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <!-- / Content -->



<?php $__env->stopSection(); ?>
<?php $__env->startSection('scripts'); ?>
    <script>
        document.addEventListener("DOMContentLoaded", function() {
            const viewDetail = document.querySelector("#perm_70");
            const ongoingList = document.querySelector("#perm_21");
            if (viewDetail && ongoingList) {
                viewDetail.addEventListener('change', function() {
                    if (this.checked) {
                        ongoingList.checked = true;
                    }
                });
            }
        });
    </script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('admin.layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/intellisensetech/public_html/aaa/resources/views/admin/roles/edit.blade.php ENDPATH**/ ?>