<table id="myTable" class="dataTable table table-hover display responsive nowrap">
    <thead>
        <tr>

            <th>
                <span class="sortable" data-sort="name" data-order="asc">
                    Name
                    <i id="sort-icon-name" class="bx bx-sort"></i>
                </span>
            </th>
            <th>
                <span class="sortable" data-sort="status" data-order="asc">
                    Status
                    <i id="sort-icon-status" class="bx bx-sort"></i>
                </span>
            </th>
            <th>
                <span class="sortable" data-sort="created_at" data-order="asc">
                    Created at
                    <i id="sort-icon-created_at" class="bx bx-sort"></i>
                </span>

            </th>
            <th>Actions</th>
        </tr>
    </thead>
    <?php if(isset($vehicleTypes) && count($vehicleTypes) > 0): ?>
        <tbody class="table-border-bottom-0">

            <?php $__currentLoopData = $vehicleTypes; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $vehicleType): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <tr>

                    <td class="text-capitalize"><?php echo e($vehicleType->name); ?></td>
                    <td>
                        <span class="badge <?php echo e(badgesforStatuses($vehicleType->status)); ?>">
                            <?php echo e(basicStatusesDisplay($vehicleType->status)); ?>

                        </span>

                    </td>
                    <td><?php echo e(dateInList($vehicleType->created_at)); ?></td>
                    <td class="<?php echo e(hideAction($vehicleType->status)); ?>">

                        <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->any(['edit-vehicle_type', 'delete-vehicle_type'])): ?>
                            <div class="dropdown">
                                <button type="button" class="btn p-0 dropdown-toggle hide-arrow" data-bs-toggle="dropdown">
                                    <i class="bx bx-dots-vertical-rounded"></i>
                                </button>
                                <div class="dropdown-menu">
                                    <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('edit-vehicle_type')): ?>
                                        <a class="dropdown-item"
                                            href="<?php echo e(route('admin.vehicle-type.edit', $vehicleType->id)); ?>"><i
                                                class="bx bx-edit-alt me-1"></i> Edit</a>
                                    <?php endif; ?>
                                    <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('delete-vehicle_type')): ?>
                                        <button data-url="<?php echo e(route('admin.vehicle-type.destroy', $vehicleType->id)); ?>"
                                            data-id="<?php echo e($vehicleType->id); ?>" type="button" class="dropdown-item delete-btn"
                                            href="javascript:void(0);"><i class="bx bx-trash me-1"></i>
                                            Delete</button>
                                    <?php endif; ?>
                                </div>
                            </div>
                        <?php endif; ?>
                    </td>

                </tr>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </tbody>
        <tfoot>
            <tr>
                <td class="" colspan="6">
                    <div class="mt-2 row justify-space-between mb-2">
                        <div class="col-md-6">
                            <div class="" id="records"><?php echo pageInfo($vehicleTypes); ?></div>
                        </div>
                        <div class="col-md-6 pagination-end">

                            <?php echo $vehicleTypes->links('pagination::bootstrap-4'); ?>


                        </div>
                    </div>
                </td>
            </tr>
        </tfoot>

    <?php endif; ?>
</table>
<?php /**PATH /home/intellisensetech/public_html/aaa/resources/views/admin/vehicleType/pagination.blade.php ENDPATH**/ ?>