<table id="myTable" class="dataTable table table-hover display responsive nowrap">
    <thead>
        <tr>

            <th>
                <span class="sortable" data-sort="name" data-order="asc">
                    Name
                    <i id="sort-icon-name" class="bx bx-sort"></i>
                </span>
            </th>
            <th>
                <span class="sortable" data-sort="status" data-order="asc">
                    Status
                    <i id="sort-icon-status" class="bx bx-sort"></i>
                </span>
            </th>
            <th>
                <span class="sortable" data-sort="created_at" data-order="asc">
                    Created at
                    <i id="sort-icon-created_at" class="bx bx-sort"></i>
                </span>

            </th>
            <th>Actions</th>
        </tr>
    </thead>
    <?php if(isset($vehicleModels) && count($vehicleModels) > 0): ?>
        <tbody class="table-border-bottom-0">

            <?php $__currentLoopData = $vehicleModels; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $vehicleModel): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <tr>

                    <td class="text-capitalize"><?php echo e($vehicleModel->name); ?></td>
                    <td>
                        <span class="badge <?php echo e(badgesforStatuses($vehicleModel->status)); ?>">
                            <?php echo e(basicStatusesDisplay($vehicleModel->status)); ?>

                        </span>
                    </td>
                    <td><?php echo e(dateInList($vehicleModel->created_at)); ?></td>
                    
                    <td class="<?php echo e(hideAction($vehicleModel->status)); ?>">
                        <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->any(['edit-vehicle_model', 'delete-vehicle_model'])): ?>
                            <div class="dropdown">
                                <button type="button" class="btn p-0 dropdown-toggle hide-arrow" data-bs-toggle="dropdown">
                                    <i class="bx bx-dots-vertical-rounded"></i>
                                </button>
                                <div class="dropdown-menu">
                                    <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('edit-vehicle_model')): ?>
                                        <a class="dropdown-item"
                                            href="<?php echo e(route('admin.vehicle-model.edit', $vehicleModel->id)); ?>"><i
                                                class="bx bx-edit-alt me-1"></i> Edit</a>
                                    <?php endif; ?>
                                    <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('delete-vehicle_model')): ?>
                                        <button data-url="<?php echo e(route('admin.vehicle-model.destroy', $vehicleModel->id)); ?>"
                                            data-id="<?php echo e($vehicleModel->id); ?>" type="button" class="dropdown-item delete-btn"
                                            href="javascript:void(0);"><i class="bx bx-trash me-1"></i>
                                            Delete</button>
                                    <?php endif; ?>
                                </div>
                            </div>
                        <?php endif; ?>
                    </td>
                </tr>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </tbody>
        <tfoot>
            <tr>
                <td class="" colspan="6">
                    <div class="mt-2 row justify-space-between mb-2">
                        <div class="col-md-6">
                            <div class="" id="records"><?php echo pageInfo($vehicleModels); ?></div>
                        </div>
                        <div class="col-md-6 pagination-end">

                            <?php echo $vehicleModels->links('pagination::bootstrap-4'); ?>


                        </div>
                    </div>
                </td>
            </tr>
        </tfoot>

    <?php endif; ?>
</table>
<?php /**PATH /home/intellisensetech/public_html/aaa/resources/views/admin/vehicleModel/pagination.blade.php ENDPATH**/ ?>