<?php $__env->startSection('title', 'Create Product'); ?>
<?php $__env->startSection('content'); ?>
    <!-- Content -->

    <div class="container-xxl flex-grow-1 container-p-y">
        

        <!-- Basic Layout & Basic with Icons -->
        <div class="row ">
            <!-- Basic Layout -->
            <div class="col-sm-12">
                <div class="card px-4 mb-4">
                    <div class="title-n-btn ">
                        <h4 class="">Create Product</h4>

                    </div>

                    <div class="card-body px-0">
                        <form class="ajax-submit-form" data-url="<?php echo e(route('admin.product.store')); ?>" data-method="POST"
                            enctype="multipart/form-data">


                            <div class="row mb-3">
                                <label class="col-sm-2 col-form-label" for="basic-default-name">Name</label>
                                <div class="col-sm-10">
                                    <input name="name" type="text" class="form-control" id="basic-default-name" />
                                </div>
                            </div>
                            <div class="row mb-3">
                                <label class="col-sm-2 col-form-label" for="vehicle_model">Vehicle Models</label>

                                <div class="col-sm-10">
                                    <select class="select2 text-capitalize" name="vehicle_model[]" id="vehicle_model"
                                        multiple="multiple">
                                        <?php $__currentLoopData = $vehicleModels; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $vehicleModel): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <option class="text-capitalize" value="<?php echo e($vehicleModel->id); ?>">

                                                Type: <?php echo e($vehicleModel->vehicleType->name ?? 'N/A'); ?>

                                                &nbsp;&nbsp;>>&nbsp;&nbsp;
                                                Make: <?php echo e($vehicleModel->vehicleMake->name ?? 'N/A'); ?>

                                                &nbsp;&nbsp;>>&nbsp;&nbsp;
                                                Model: <?php echo e($vehicleModel->name); ?>



                                            </option>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>


                                    </select>


                                </div>
                            </div>
                            <div class="row mb-3">
                                <label class="col-sm-2 col-form-label" for="price">Price</label>
                                <div class="col-sm-3">
                                    
                                    <div class="input-group">
                                        <span class="input-group-text" id="basic-addon13">USD</span>
                                        <input type="number" step="0.01" min="0" name="price_in_usd"
                                            id="price_in_usd" class="form-control" placeholder="" aria-label="price_in_usd"
                                            aria-describedby="basic-addon13" />

                                    </div>
                                </div>
                                <div class="col-sm-3">
                                    <div class="input-group">
                                        <span class="input-group-text" id="basic-addon13">MMK</span>
                                        <input type="number" step="0.01" min="0" name="price_in_mmk"
                                            id="price_in_mmk" class="form-control" placeholder="" aria-label="price_in_mmk"
                                            aria-describedby="basic-addon13" />

                                    </div>
                                </div>
                                <div class="col-sm-3">
                                    <div class="input-group">
                                        <span class="input-group-text" id="basic-addon13">RMB</span>
                                        <input type="number" step="0.01" min="0" name="price_in_rmb"
                                            id="price_in_rmb" class="form-control" placeholder="" aria-label="price_in_rmb"
                                            aria-describedby="basic-addon13" />

                                    </div>
                                </div>

                            </div>

                            <div class="row mb-3">
                                <label class="col-sm-2 col-form-label" for="images">Featured Image</label>
                                <div class="col-sm-10">
                                    
                                    <input type="file" name="feature_image" class="form-control" id="feature_image">

                                </div>
                            </div>

                            <div class="row mb-3">
                                <label class="col-sm-2 col-form-label" for="description">Description</label>
                                <div class="col-sm-10">
                                    <textarea name="description" id="description" class="form-control" cols="30" rows="10"></textarea>
                                </div>
                            </div>

                            <div class="row mb-3">
                                <label class="col-sm-2 col-form-label" for="status">Status</label>
                                <div class="col-sm-10">
                                    <select class="select2" name="status" id="status">
                                        <?php $__currentLoopData = CommonStatusesForCrud(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $value): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <option value="<?php echo e($key); ?>"><?php echo e($value); ?></option>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>


                                    </select>

                                </div>
                            </div>
                            <div class="row mb-3">
                                <label class="col-sm-2 col-form-label" for="images">Gallery</label>
                                <div class="col-sm-10">
                                    
                                    
                                    <div id="gallery-dropzone" class="dropzone"></div>
                                    <p id="images-error" class="invalid-feedback d-block text-danger"></p>
                                </div>
                            </div>
                            <div class="row justify-content-end">
                                <div class="col-sm-10">
                                    <div class="form-check">
                                        <input class="form-check-input" type="checkbox" value="" id="is_featured"
                                            name="is_featured">
                                        <label class="form-check-label" for="is_featured">
                                            Set as Featured Product
                                        </label>
                                    </div>
                                </div>
                            </div>
                            <div class="row justify-content-end pt-3">
                                <div class="col-sm-10">
                                    <button type="submit" class="btn btn-primary">Create</button>
                                </div>
                            </div>
                        </form>
                    </div>
                </div>
            </div>

        </div>
    </div>

    <!-- / Content -->
<?php $__env->stopSection(); ?>
<?php $__env->startSection('scripts'); ?>
    <script>
        var existingImages = [];

        const usdToMmkRate = <?php echo e($currrncyRateMmk ?? 0); ?>

        const usdToRmbRate = <?php echo e($currrncyRateRmb ?? 0); ?>

        // When typing in USD field
        $('#price_in_usd').on('input', function() {
            let usd = parseFloat($(this).val());
            if (!isNaN(usd)) {
                let mmk = (usd * usdToMmkRate).toFixed(2);
                let rmb = (usd * usdToRmbRate).toFixed(2);
                $('#price_in_mmk').val(mmk);
                $('#price_in_rmb').val(rmb);
            } else {
                $('#price_in_mmk').val('');
                $('#price_in_rmb').val('');
            }
        });

        // When typing in MMK field
        $('#price_in_mmk').on('input', function() {
            let mmk = parseFloat($(this).val());
            if (!isNaN(mmk)) {

                let usd = (mmk / usdToMmkRate).toFixed(2);
                $('#price_in_usd').val(usd);
                let rmb = (usd * usdToRmbRate).toFixed(2);

                $('#price_in_rmb').val(rmb);
            } else {
                $('#price_in_usd').val('');
                $('#price_in_rmb').val('');
            }
        });
        // When typing in RMB field
        $('#price_in_rmb').on('input', function() {
            let rmb = parseFloat($(this).val());
            let mmk = parseFloat($('#price_in_mmk').val());
            if (!isNaN(rmb)) {
                let usd = (rmb / usdToRmbRate).toFixed(2);
                $('#price_in_usd').val(usd);
                let mmk = (usd * usdToMmkRate).toFixed(2);
                $('#price_in_mmk').val(mmk);
            } else {
                $('#price_in_usd').val('');
                $('#price_in_mmk').val('');

            }
        });
    </script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('admin.layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/intellisensetech/public_html/aaa/resources/views/admin/product/create.blade.php ENDPATH**/ ?>