<?php

use App\Helpers\NotificationHelper;
use App\Http\Controllers\Admin\Auth\LoginController;
use App\Http\Controllers\Admin\BannerController;
use App\Http\Controllers\Admin\ChatContoller;
use App\Http\Controllers\Admin\CustomerController;
use App\Http\Controllers\Admin\DashboardController;
use App\Http\Controllers\Admin\DepartmentController;
use App\Http\Controllers\Admin\EmployeeController;
use App\Http\Controllers\Admin\OrderController;
use App\Http\Controllers\Admin\ProductController;
use App\Http\Controllers\Admin\ProfileController;
use App\Http\Controllers\Admin\ReviewController;
use App\Http\Controllers\Admin\RoleController;
use App\Http\Controllers\Admin\SettingController;
use App\Http\Controllers\Admin\VehicleMakeController;
use App\Http\Controllers\Admin\VehicleModelController;
use App\Http\Controllers\Admin\VehicleTypeController;
use App\Http\Controllers\Admin\WholesaleIDController;
use App\Http\Controllers\Api\HomeController;
use App\Http\Controllers\BroadcastAuthController;
use App\Http\Controllers\CronController;
use App\Models\Customer;
use Illuminate\Support\Facades\Route;

/*
|--------------------------------------------------------------------------
| Web Routes
|--------------------------------------------------------------------------
|
| Here is where you can register web routes for your application. These
| routes are loaded by the RouteServiceProvider within a group which
| contains the "web" middleware group. Now create something great!
|
*/

Route::get('/', function () {
    return redirect()->route('admin.login');
});
Route::get('/login', function () {
    return redirect()->route('admin.login');
});

Route::prefix('admin')->name('admin.')->group(function () {
    Route::middleware('admin.guest')->group(function () {
        Route::get('login', [LoginController::class, 'login'])->name('login');
        Route::post('login/submit', [LoginController::class, 'loginSubmit'])->name('login.submit');
        //redirect admin to login
        Route::redirect('/', 'login');
    });

    //Route::get('store', [LoginController::class, 'store']);
    Route::middleware('auth:admin')->group(function () {
        //for pusher
        Route::post('broadcast', [BroadcastAuthController::class, 'auth']);
        Route::get('dashboard', [DashboardController::class, 'index'])->name('dashboard');
        Route::Resource('vehicle-type', VehicleTypeController::class);
        Route::Resource('vehicle-make', VehicleMakeController::class);
        Route::Resource('vehicle-model', VehicleModelController::class);
        Route::Resource('product', ProductController::class);
        Route::get('vehicle-types/by-make/{makeId}', [VehicleModelController::class, 'getVehicleTypes']);
        Route::delete('product/image/{id}', [ProductController::class, 'deleteImage'])->name('product.image.delete');
        //product filter routes
        Route::get('products/get-vehicle-makes', [ProductController::class, 'getVehicleMakes'])->name('product.getVehicleMakes');
        Route::get('products/get-vehicle-models', [ProductController::class, 'getVehicleModels'])->name('product.getVehicleModels');
        Route::get('customer', [CustomerController::class, 'index'])->name('customer.index');
        Route::get('customer/{id}/edit', [CustomerController::class, 'edit'])->name('customer.edit');
        Route::put('customer/{id}/update', [CustomerController::class, 'update'])->name('customer.update');
        Route::post('customer/{id}/apply-discount', [CustomerController::class, 'applyDiscount'])->name('customer.applyDiscount');
        Route::put('customer/{id}/deactivate-discount', [CustomerController::class, 'deactivateDiscount'])->name('customer.deactivateDiscount');
        Route::delete('customer/{id}/delete', [CustomerController::class, 'destroy'])->name('customer.destroy');
        Route::post('/check-vehicle-models', [VehicleMakeController::class, 'checkVehicleModels'])->name('vehicleMake.checkVehicleModels');
        Route::post('/delete-vehicle-models', [VehicleMakeController::class, 'deleteVehicleModels'])->name('vehicleMake.deleteVehicleModels');
        Route::get('setting/return-days', [SettingController::class, 'returnDays'])->name('setting.returnDays');
        Route::post('/setting/update-return-days', [SettingController::class, 'updateReturnDays'])->name('setting.updateReturnDays');
        Route::get('setting/currency', [SettingController::class, 'currencyConversion'])->name('setting.currency');
        Route::post('setting/currency-update', [SettingController::class, 'updateCurrencyConversion'])->name('setting.updateCurrencyConversion');
        Route::get('setting/tax', [SettingController::class, 'tax'])->name('setting.tax');
        Route::post('setting/tax-update', [SettingController::class, 'updateTax'])->name('setting.updateTax');
        Route::get('my-profile', [ProfileController::class, 'editProfile'])->name('profile');
        Route::post('profile-update', [ProfileController::class, 'updateProfile'])->name('profile.update');
        Route::resource('wholesale-plan', WholesaleIDController::class);
        Route::get('/orders', [OrderController::class, 'index'])->name('orders.index');
        Route::get('/orders/pagination', [OrderController::class, 'pagination'])->name('orders.pagination');
        Route::get('orders/{id}', [OrderController::class, 'show'])->name('orders.show');
        Route::put('order/{id}/update', [OrderController::class, 'updateOrderStatus'])->name('orders.update');
        Route::put('order/{id}/refund', [OrderController::class, 'refundOrder'])->name('ordersRefund.update');
        Route::put('order/{id}/items-received', [OrderController::class, 'itemsReceived'])->name('ordersItemsReceived.update');
        Route::put('order/{id}/mark-paid', [OrderController::class, 'mark_paid'])->name('ordersPayment.update');
        //Route::put('order/{id}/mark-payment-failed', [OrderController::class, 'markPaymentFailed'])->name('markPaymentFailed');
        // update return or cancel goods by orders
        Route::put('order/{id}/update-stock', [OrderController::class, 'updateStock'])->name('orders.updateStock');
        //Cancelled orders
        Route::put('return-order/{id}/update', [OrderController::class, 'updateReturnOrder'])->name('orderReturn.update');
        Route::put('cancel-order/{id}/update', [OrderController::class, 'updateCancelOrder'])->name('orderCancellations.update');
        Route::resource('department', DepartmentController::class);
        Route::resource('employee', EmployeeController::class);
        Route::get('permission/create', [EmployeeController::class, 'createPermission'])->name('employee.createPermission');
        Route::post('permission/store', [EmployeeController::class, 'storePermission'])->name('employee.storePermission');
        Route::resource('role', RoleController::class);
        Route::post('logout', [LoginController::class, 'logout'])->name('logout');
        //manage inventory
        Route::get('product/{id}/manage-inventory', [ProductController::class, 'manageInventory'])->name('product.manageInventory');
        Route::post('product/{id}/manage-inventory/update', [ProductController::class, 'updateInventory'])->name('product.manageInventory.updateInventory');
        //pages
        Route::get('/pages/about-us', [SettingController::class, 'aboutUs'])->name('pages.aboutUs');
        Route::post('/pages/about-us-update', [SettingController::class, 'aboutUsUpdate'])->name('pages.aboutUsUpdate');
        Route::get('/pages/privacy-policy', [SettingController::class, 'privacyPolicy'])->name('pages.privacyPolicy');
        Route::post('/pages/privacy-policy-update', [SettingController::class, 'privacyPolicyUpdate'])->name('pages.privacyPolicyUpdate');
        Route::get('/pages/terms-conditions', [SettingController::class, 'termsConditions'])->name('pages.termsConditions');
        Route::post('/pages/terms-conditions-update', [SettingController::class, 'termsConditionsUpdate'])->name('pages.termsConditionsUpdate');
        //banners
        Route::resource('banner', BannerController::class);
        //review rating
        Route::get('/reviews', [ReviewController::class, 'index'])->name('product.review');
        Route::get('/reviews/{id}', [ReviewController::class, 'show'])->name('product.review.show');
        Route::put('/reviews/{id}/update-status', [ReviewController::class, 'update'])->name('product.review.update');
        //send message
        Route::post('/chat/{conversationId}/send', [ChatContoller::class, 'sendMessage'])->name('chat.send');
        //get conversation
        Route::get('/chat', [ChatContoller::class, 'fetchConversation'])->name('chat');
        //show messages
        Route::get('/chat/{conversation}/messages', [ChatContoller::class, 'showMessages'])->name('chat.show');
        //attcahments in messages send
        Route::post('/chat/upload', [ChatContoller::class, 'upload'])->name('chat.upload');
        //close the conversation
        Route::put('/chat/coversation-close', [ChatContoller::class, 'closeConversation'])->name('chat.closeConversation');
    });
});
Route::get('set-wholesale-plan-expiry', [CronController::class, 'checkWholesalePlan']);
//web views
Route::get('/about-us/{lang}', [SettingController::class, 'aboutUsWebView'])->name('aboutUs');
Route::get('/privacy-policy/{lang}', [SettingController::class, 'privacyPolicyWebView'])->name('privacyPolicy');
Route::get('/terms-conditions/{lang}', [SettingController::class, 'termsConditionsWebView'])->name('termsConditions');
Route::get('seedCurrencyMasetr', [HomeController::class, 'seedCurrencyMasetr']);
