<?php

use App\Http\Controllers\Admin\OrderController;
use App\Http\Controllers\Api\ProfileController as CustomerProfileController;
use App\Http\Controllers\Api\AuthController;
use App\Http\Controllers\Api\CartController;
use App\Http\Controllers\Api\CheckoutController;
use App\Http\Controllers\Api\ConversationController;
use App\Http\Controllers\Api\CustomerAddressController;
use App\Http\Controllers\Api\HomeController;
use App\Http\Controllers\Api\MessageController;
use App\Http\Controllers\Api\SupportController;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Route;
use App\Http\Controllers\Api\ProductController as APIProductController;
use App\Http\Controllers\Api\OrderController as APIOrderController;
use App\Http\Controllers\Api\ReviewRatingController;
use App\Http\Controllers\Api\TrascationController;
use App\Http\Controllers\BroadcastAuthController;

/*
|--------------------------------------------------------------------------
| API Routes
|--------------------------------------------------------------------------
|
| Here is where you can register API routes for your application. These
| routes are loaded by the RouteServiceProvider within a group which
| is assigned the "api" middleware group. Enjoy building your API!
|
*/

//auth routes
Route::post('register', [AuthController::class, 'register']);
Route::post('verify-mobile-user', [AuthController::class, 'verifyMobileOtp']);
Route::post('verify-email-id', [AuthController::class, 'verifyEmailOtp']);
Route::post('resend-otp', [AuthController::class, 'resendOtp']);
Route::post('login', [AuthController::class, 'login']);
Route::post('forgot-password', [AuthController::class, 'forgotPassword']);
Route::post('verify-forgot-password-otp', [AuthController::class, 'verifyForgotPasswordOtp']);
Route::post('change-forgot-password', [AuthController::class, 'changeForgotPassword']);





Route::middleware('auth:sanctum')->group(function () {

    //auth
    Route::post('logout', [AuthController::class, 'logout']);
    //profile setting
    Route::get('get-profile', [CustomerProfileController::class, 'getProfile']);
    Route::post('update-profile', [CustomerProfileController::class, 'updateProfile']);
    Route::post('update-profile-image', [CustomerProfileController::class, 'updateProfileImage']);
    Route::post('change-password', [CustomerProfileController::class, 'changePassword']);
    Route::post('delete-account', [CustomerProfileController::class, 'deleteAccount']);
    Route::post('contact-us', [SupportController::class, 'contactUs']);
    Route::post('/get-pages-links', [SupportController::class, 'getPagesLinks']);
    //dashboard
    Route::get('dashboard', [HomeController::class, 'dashboard']);
    Route::get('vehicle-types', [HomeController::class, 'vehicleTypes']);
    Route::post('vehicle-makes', [HomeController::class, 'vehicleMake']);
    Route::post('vehicle-models', [HomeController::class, 'vehicleModel']);
    Route::post('filtered-products', [HomeController::class, 'filteredProducts']);
    Route::post('get-notifications', [HomeController::class, 'getNotifications']);
    Route::post('mark-notification-read', [HomeController::class, 'markNotificationRead']);
    //currencies
    Route::get('get_all_currencies', [CustomerProfileController::class, 'getAllCurrencies']);
    Route::post('update_currency', [CustomerProfileController::class, 'updateCurrency']);
    //products
    Route::post('view-all-products', [APIProductController::class, 'viewAllProducts']);
    Route::post('product-detail/', [APIProductController::class, 'productDetail']);
    Route::post('/review-rating-submit', [ReviewRatingController::class, 'store']);
    Route::post('/show-review-rating', [ReviewRatingController::class, 'show']);
    Route::post('/product-reviews', [APIProductController::class, 'productReviews']);

    //cart 
    Route::post('/cart', [CartController::class, 'updateCart']);
    Route::post('/view-cart', [CartController::class, 'viewCart']);
    Route::post('/delete-cart', [CartController::class, 'deleteCart']);
    //checkout saveCheckoutAddress
    Route::get('/checkout-review', [CheckoutController::class, 'checkoutReview']);
    Route::post('/save-checkout-address', [CheckoutController::class, 'saveCheckoutAddress']);
    Route::get('/get-checkout-address', [CheckoutController::class, 'getCheckoutAddress']);
    Route::get('/is-returning-customer', [CheckoutController::class, 'isReturningCustomer']);
    Route::post('/country-info-dial-code', [CheckoutController::class, 'countryInfoDialCode']);


    //orders apis
    Route::post('/order-placed', [APIOrderController::class, 'placeOrder']);
    Route::post('/order-history', [APIOrderController::class, 'orderHistory']);
    Route::post('/order-history-detail', [APIOrderController::class, 'orderHistoryDetail']);
    Route::post('/order-update-status', [APIOrderController::class, 'orderUpdateStatus']);
    //payment
    Route::post('/upload-payment-proof', [TrascationController::class, 'uploadPaymentProof']);

    //addresses
    Route::post('/create-address', [CustomerAddressController::class, 'store']);
    Route::post('/update-address', [CustomerAddressController::class, 'update']);
    Route::get('/get-addresses', [CustomerAddressController::class, 'index']);
    Route::post('/delete-address', [CustomerAddressController::class, 'destroy']);
    Route::post('/set-default-address', [CustomerAddressController::class, 'setDefaultAddress']);
    Route::get('/get-default-address', [CustomerAddressController::class, 'getDefaultAddress']);
    //cashback plans
    Route::get('/get-cashback-plans', [CustomerProfileController::class, 'getCashbackPlans']);
    Route::post('/cashback-plans/assign', [CustomerProfileController::class, 'assignCashbackPlan']);
    //get countrirs,sttae,cities
    Route::get('/countries', [CustomerAddressController::class, 'getAllCountries']);
    Route::get('/countries/states/{country_id}', [CustomerAddressController::class, 'getStatesByCountry']);
    Route::get('/countries/states/cites/{state_id}', [CustomerAddressController::class, 'getCitiesByState']);
    //conversation
    Route::post('submit-conversation', [ConversationController::class, 'store']);
    //messages
    Route::post('get-messages', [MessageController::class, 'index']);
    Route::post('submit-message', [MessageController::class, 'store']);
});
