<table id="myTable" class="dataTable table table-hover display responsive nowrap">
    <thead>
        <tr>

            <th>
                <span class="sortable" data-sort="name" data-order="asc">
                    Name
                    <i id="sort-icon-name" class="bx bx-sort"></i>
                </span>
            </th>
            <th>
                <span class="sortable" data-sort="status" data-order="asc">
                    Status
                    <i id="sort-icon-status" class="bx bx-sort"></i>
                </span>
            </th>
            <th>
                <span class="sortable" data-sort="created_at" data-order="asc">
                    Created at
                    <i id="sort-icon-created_at" class="bx bx-sort"></i>
                </span>

            </th>
            <th>Actions</th>
        </tr>
    </thead>
    @if (isset($vehicleMakes) && count($vehicleMakes) > 0)
        <tbody class="table-border-bottom-0">

            @foreach ($vehicleMakes as $vehicleMake)
                <tr>

                    <td class="text-capitalize">{{ $vehicleMake->name }}</td>
                    <td>
                        <span class="badge {{ badgesforStatuses($vehicleMake->status) }}">
                            {{ basicStatusesDisplay($vehicleMake->status) }}
                        </span>

                    </td>
                    <td>{{ dateInList($vehicleMake->created_at) }}</td>
                    {{-- <td><span class="badge bg-label-primary me-1">Active</span></td> --}}
                    <td class="{{ hideAction($vehicleMake->status) }}">
                        @canany(['edit-vehicle_make', 'delete-vehicle_make'])
                            <div class="dropdown">
                                <button type="button" class="btn p-0 dropdown-toggle hide-arrow" data-bs-toggle="dropdown">
                                    <i class="bx bx-dots-vertical-rounded"></i>
                                </button>
                                <div class="dropdown-menu">
                                    @can('edit-vehicle_make')
                                        <a class="dropdown-item"
                                            href="{{ route('admin.vehicle-make.edit', $vehicleMake->id) }}"><i
                                                class="bx bx-edit-alt me-1"></i> Edit</a>
                                    @endcan
                                    @can('delete-vehicle_make')
                                        <button data-url="{{ route('admin.vehicle-make.destroy', $vehicleMake->id) }}"
                                            data-id="{{ $vehicleMake->id }}" type="button" class="dropdown-item delete-btn"
                                            href="javascript:void(0);"><i class="bx bx-trash me-1"></i>
                                            Delete</button>
                                    @endcan
                                </div>
                            </div>
                        @endcanany
                    </td>
                </tr>
            @endforeach
        </tbody>
        <tfoot>
            <tr>
                <td class="" colspan="6">
                    <div class="mt-2 row justify-space-between mb-2">
                        <div class="col-md-6">
                            <div class="" id="records">{!! pageInfo($vehicleMakes) !!}</div>
                        </div>
                        <div class="col-md-6 pagination-end">

                            {!! $vehicleMakes->links('pagination::bootstrap-4') !!}

                        </div>
                    </div>
                </td>
            </tr>
        </tfoot>

    @endif
</table>
