@extends('admin.layouts.app')
@section('title', 'Privacy Policy')
@section('content')
    <div class="content-wrapper">
        <!-- Content -->

        <div class="content-wrapper">
            <!-- Content -->

            <div class="container-xxl flex-grow-1 container-p-y">
                @if ($errors->any())
                    <div class="alert alert-danger">
                        <ul>
                            @foreach ($errors->all() as $error)
                                <li>{{ $error }}</li>
                            @endforeach
                        </ul>
                    </div>
                @endif

                <!-- Basic Layout -->
                <div class="row">
                    <div class="col-xl">
                        <div class="card mb-4">
                            <div class="card-header border-b d-flex justify-content-between align-items-center">
                                <h5 class="mb-0 text-dark text-uppercase">Privacy Policy</h5>

                            </div>

                            <div class="card-body pt-5">
                                <form class="ajax-submit-form" data-url="{{ route('admin.pages.privacyPolicyUpdate') }}"
                                    data-method="POST" enctype="multipart/form-data">

                                    <div class="row page-management-align">
                                        <div class="col-md-3 col-sm-12 text-right pt-2">
                                            <div class="mb-3">
                                                <label class="form-label" for="basic-default-fullname">Privacy Policy
                                                    Content</label>
                                            </div>
                                        </div>
                                        <div class="col-md-9 col-sm-12">
                                            <div class="mb-3">
                                                <textarea name="privacy_policy_en" class="privacy_policy_en" id="privacy_policy_en" cols="30" rows="10">{!! $privacy_policy_en->value ?? '' !!}</textarea>
                                            </div>
                                        </div>
                                    </div>

                                    <div class="submit-btn-outer my-3 offset-md-3">
                                        <button type="submit" class="btn btn-primary">Update Details</button>
                                    </div>

                                </form>


                            </div>
                        </div>
                    </div>
                </div>

            </div>
        </div>
        <!-- / Content -->




    @endsection

    @section('scripts')
        <script>
            CKEDITOR.replace('privacy_policy_en');
        </script>

    @endsection
