@extends('admin.layouts.app')
@section('title', 'Role List')
@section('content')
    <div class="content-wrapper">

        <!-- Content -->
        <div class="container-xxl flex-grow-1 container-p-y">
            <div class="row ">
                <div class="col-12">
                    <!-- Hoverable Table rows -->
                    <div class="card px-4 pt-4 pb-4">

                        @if (session('success'))
                            <div class="alert alert-success pt-2">
                                {{ session('success') }}
                            </div>
                        @endif
                        @if (session('error'))
                            <div class="alert alert-danger pt-2">
                                {{ session('error') }}
                            </div>
                        @endif



                        <div class=" d-flex justify-content-between align-items-center pb-2">
                            <h3 class=" text-dark">Role List</h3>

                        </div>
                        <div class="row">
                            <div class="col-md-12">
                                <div id="pagination-table">
                                    <table class="dataTable dt-responsive table table-hover display align-middle mb-0">
                                        <thead>
                                            <tr>

                                                <th>
                                                    Name </th>
                                                <th> Department</th>

                                                <th> Actions</span></th>
                                            </tr>
                                        </thead>
                                        @if (isset($roles) && count($roles) > 0)
                                            <tbody class="table-border-bottom-0">

                                                @foreach ($roles as $role)
                                                    <tr>


                                                        <td class="text-capitalize">{{ $role->actual_name }}</td>
                                                        <td class="text-capitalize">{{ $role->department->name }}</td>
                                                        <td>



                                                            <div class="d-flex">


                                                                <a class="btn-role"
                                                                    href="{{ route('admin.role.edit', $role->id) }}">
                                                                    <i class="bx bx-edit"></i></a>


                                                                <button class="delete-btn btn-role"
                                                                    data-url="{{ route('admin.role.destroy', $role->id) }}"
                                                                    data-id="{{ $role->id }}"><i
                                                                        class="bx bx-trash me-1"></i>
                                                                </button>


                                                            </div>






                                                        </td>
                                                    </tr>



                                            </tbody>
                                        @endforeach
                                        @endif
                                    </table>

                                </div>
                            </div>
                        </div>

                    </div>
                    <!--/ Hoverable Table rows -->
                </div>
            </div>

        </div>
        <!-- / Content -->
    @endsection
