@extends('admin.layouts.app')
@section('title', 'Show Review')
@section('content')
    <!-- Content -->

    <div class="container-xxl flex-grow-1 container-p-y">
        {{-- <h4 class="fw-bold py-3 mb-4"><span class="text-muted fw-light">Forms/</span> Horizontal Layouts</h4> --}}

        <!-- Basic Layout & Basic with Icons -->
        <div class="row ">
            <!-- Basic Layout -->
            <div class="col-sm-12">
                <div class="card px-4 mb-4">
                    <div class="flex-with-no-align ">
                        <h4 class="title-no-margin">Approve or Reject the Review</h4>
                        <span class="badge {{ \App\Helpers\CommonHelper::$badgesforStatuses[$review->status] }}">
                            {{ \App\Helpers\CommonHelper::$approvalStatuses[$review->status] }}
                        </span>
                        @if ($review->verified_customer)
                            <span class="badge bg-danger">
                                <i class="fas fa-check-circle"></i>
                                Purchase Verified
                            </span>
                        @endif

                    </div>

                    <div class="card-body px-0">


                        <div class="row mb-3">
                            <label class="col-sm-2 col-form-label" for="basic-default-name">Product</label>
                            <div class="col-sm-10">
                                <input name="name" type="text" class="form-control" id="basic-default-name"
                                    value="{{ $review->product->name }}" readonly />

                            </div>
                        </div>
                        <div class="row mb-3">
                            <label class="col-sm-2 col-form-label" for="basic-default-name">Customer</label>
                            <div class="col-sm-10">
                                <input name="name" type="text" class="form-control" id="basic-default-name"
                                    value="{{ $review->customer->full_name }}" readonly />

                            </div>
                        </div>
                        <div class="row mb-3">
                            <label class="col-sm-2 col-form-label" for="basic-default-name">Review</label>
                            <div class="col-sm-10">
                                <textarea name="review_data" class="form-control" id="review_data" rows="3" readonly>{{ $review->review }}
                                </textarea>


                            </div>
                        </div>
                        @if ($review->attachments && count($review->attachments) > 0)



                            <div class="row mb-3">
                                <label class="col-sm-2 col-form-label" for="images">Attached Media</label>
                                <div class="col-sm-10">




                                    <div class="row">
                                        @foreach ($review->attachments as $media)
                                            <div class="col-lg-2 col-md-3 col-sm-6 pb-3">


                                                @if ($media->type == 'image')
                                                    <a data-type="image" data-fancybox="gallery"
                                                        href="{{ asset($media->path) }}">
                                                        <img class="media-item" src="{{ asset($media->path) }}" />
                                                    </a>
                                                @elseif($media->type == 'video')
                                                    <a data-fancybox="gallery" href="{{ asset($media->path) }}">
                                                        <img class="media-item" src="{{ asset($media->path) }}" />
                                                    </a>
                                                @else
                                                    <span class="text-muted">No media</span>
                                                @endif

                                            </div>
                                        @endforeach

                                    </div>





                                </div>
                            </div>
                        @endif

                        @if ($review->status == 0)
                            <div class="row justify-content-end pt-3">
                                <div class="col-sm-10 d-flex gap-3">
                                    <form class="ajax-submit-form"
                                        data-url="{{ route('admin.product.review.update', $review->id) }}"
                                        data-method="post">
                                        @method('put')
                                        <input type="hidden" name="status" value="1">
                                        <button type="submit" class="btn btn-success">
                                            <i class="fas fa-check"></i> Approve
                                        </button>
                                    </form>

                                    <form class="ajax-submit-form"
                                        data-url="{{ route('admin.product.review.update', $review->id) }}"
                                        data-method="post">
                                        @method('put')
                                        <input type="hidden" name="status" value="2">
                                        <button type="submit" class="btn btn-danger">
                                            <i class="fas fa-times"></i> Reject
                                        </button>
                                    </form>
                                </div>
                            </div>
                        @endif






                    </div>
                </div>
            </div>

        </div>
    </div>

    <!-- / Content -->
@endsection
@section('scripts')

@endsection
