@extends('admin.layouts.app')
@section('title', 'Order Detail')
@section('content')
    @php
        $currencySymbol = App\Helpers\CommonHelper::getCurrencyInfo($order->currency_code)->currency_symbol ?? '';
    @endphp
    <!-- Content -->
    <div class="container-xxl flex-grow-1 container-p-y">

        <!-- Basic Layout & Basic with Icons -->
        <div class="row " id="order-main">
            <!-- Basic Layout -->
            <div class="col-lg-4 col-sm-6">
                <div class="card px-4 mb-4">
                    <div class="card-body px-0">
                        <h4 class="">Customer Detail</h4>

                        <div class="d-flex align-items-center">
                            <div class="customer-image">
                                @php
                                    $image = DEFAULT_PATH;
                                    if (!empty($order->customer->image)) {
                                        $image = $order->customer->image;
                                    }

                                @endphp

                                <img src="{{ asset($image) }}" alt="Customer Image" width="60" height="60"
                                    class="rounded-circle">
                            </div>
                            <div class="customer-info">
                                <p class="customer-name">{{ $order->customer->full_name }}</p>

                            </div>
                        </div>
                        <div class="customer-contact-wrapper">
                            <p class="customer-contact"><i class="fas fa-envelope"></i> {{ $order->customer->email }}
                            </p>
                            <p class="customer-contact"><i class="fas fa-mobile-alt"></i>
                                {{ $order->customer->dial_code }} {{ $order->customer->mobile_number }}
                            </p>
                        </div>



                    </div>
                </div>
            </div>
            <div class="col-lg-4 col-sm-6">



                <div class="card px-4 mb-4">
                    <div class="card-body px-0">
                        <div class=" mb-4">
                            <h4 class="primary-title fw-bold ">Order #<span
                                    class="order_id text-danger">{{ $order->order_number }}</span>

                            </h4>
                            <div class="badge {{ badgeForOrderStatuses($order->order_status) }}">
                                {{ orderStatuses($order->order_status) }}

                            </div>
                            <span class="badge {{ $order->admin_payment_status_data['badge'] }}">
                                <i class="fas {{ $order->admin_payment_status_data['icon'] }}"></i>
                                {{ $order->admin_payment_status_data['label'] }}
                            </span>

                            {{-- display waiting for customer pay --}}
                            {{-- @if ($order->transaction?->payment_status == 'pending' && $order->order_status == 1)
                                <div class="indicator-wrapper">
                                    <div class="indicator"></div>
                                    <p>Waiting for customer payment</p>
                                </div>
                            @endif --}}




                            @if (in_array($order->order_status, [4, 5, 8, 9]) && $order->payment_status == 1)
                                @if (in_array($order->order_status, [4, 9]))
                                    {{-- items received --}}
                                    <span
                                        class="badge {{ \App\Helpers\CommonHelper::itemsReceivedBadges($order->orderCancel?->items_received) }}">
                                        {{ \App\Helpers\CommonHelper::$itemsReceivedStatus[$order->orderCancel?->items_received] ?? 'Uknown' }}
                                    </span>

                                    {{-- //refund --}}
                                    <span
                                        class="badge {{ \App\Helpers\CommonHelper::refundBadgeClass($order->orderCancel?->refund_status) }}">
                                        {{ \App\Helpers\CommonHelper::$refundStatuses[$order->orderCancel?->refund_status] ?? 'Uknown' }}
                                    </span>
                                @elseif (in_array($order->order_status, [5, 8]))
                                    {{-- items received --}}
                                    <span
                                        class="badge {{ \App\Helpers\CommonHelper::itemsReceivedBadges($order->orderReturn?->items_received) }}">
                                        {{ \App\Helpers\CommonHelper::$itemsReceivedStatus[$order->orderReturn?->items_received] ?? 'Uknown' }}
                                    </span>
                                    {{-- refund --}}
                                    <span
                                        class="badge {{ \App\Helpers\CommonHelper::refundBadgeClass($order->orderReturn?->refund_status) }}">
                                        {{ \App\Helpers\CommonHelper::$refundStatuses[$order->orderReturn?->refund_status] ?? 'Unknown' }}
                                    </span>
                                @endif
                            @endif


                        </div>
                        {{-- order total items --}}
                        <div class="d-flex mb-0 order-total-items">
                            <h5>Total Items : </h5>
                            <h5>{{ $order->total_items }}</h5>
                        </div>

                        {{-- set update status with current status wise --}}
                        {{-- <h5 class="">Update Status</h5> --}}


                        @can('view-order-detail-order')
                            @if (in_array($order->order_status, [5, 8]))
                                <div class="issueinfo">
                                    <div class="d-flex">
                                        <div class="col-4">
                                            <p class=""><b>Return Reason : </b></p>
                                        </div>
                                        <div class="col-8">
                                            <p>&nbsp;{{ $order->orderReturn->reason }}</p>
                                        </div>


                                    </div>
                                </div> {{-- return date --}}
                                @if ($order->orderReturn->created_at)
                                    <div class="d-flex">
                                        <div class="col-4">
                                            <p class=""><b>Return at : </b></p>
                                        </div>
                                        <div class="col-8">
                                            <p class="text-capitalize text-danger">
                                                <b>&nbsp;&nbsp;{{ \App\Helpers\CommonHelper::formatDate($order->orderReturn->created_at, $order->customer?->timezone) }}</b>
                                            </p>
                                        </div>

                                    </div>
                                @endif
                                {{-- return items received date --}}
                                @if ($order->orderReturn->items_received_at)
                                    <div class="d-flex">
                                        <div class="col-4">
                                            <p class=""><b>Items received at : </b></p>
                                        </div>
                                        <div class="col-8">
                                            <p class="text-capitalize text-danger">
                                                <b>&nbsp;&nbsp;{{ \App\Helpers\CommonHelper::formatDate($order->orderReturn->items_received_at, $order->customer?->timezone) }}</b>
                                            </p>
                                        </div>
                                    </div>
                                @endif
                                {{-- return refund date --}}
                                @if ($order->orderReturn->refund_at)
                                    <div class="d-flex">
                                        <div class="col-4">
                                            <p class=""><b>Refund at : </b></p>
                                        </div>
                                        <div class="col-8">
                                            <p class="text-capitalize text-danger">
                                                <b>&nbsp;&nbsp;{{ \App\Helpers\CommonHelper::formatDate($order->orderReturn->refund_at, $order->customer?->timezone) }}</b>
                                            </p>
                                        </div>
                                    </div>
                                @endif
                            @elseif (in_array($order->order_status, [4, 9]))
                                <div class="issueinfo">
                                    <div class="d-flex">
                                        <div class="col-4">
                                            <p><b>Cancel Reason : </b></p>
                                        </div>
                                        <div class="col-8">
                                            <p class="text-capitalize">&nbsp; &nbsp;{{ $order->orderCancel->reason }}</p>
                                        </div>


                                    </div>
                                    @if ($order->orderCancel->cancel_by_type == ADMIN)
                                        <div class="d-flex">
                                            <div class="col-4">
                                                <p class=""><b>Cancel By : </b></p>
                                            </div>
                                            <div class="col-8">
                                                <p class="text-capitalize text-danger">
                                                    <b>&nbsp;&nbsp;Admin</b>
                                                </p>
                                            </div>



                                        </div>
                                    @endif
                                    {{-- cacnel date --}}
                                    @if ($order->orderCancel->created_at)
                                        <div class="d-flex">
                                            <div class="col-4">
                                                <p class=""><b>Cancel at : </b></p>
                                            </div>
                                            <div class="col-8">
                                                <p class="text-capitalize text-danger">
                                                    <b>&nbsp;&nbsp;{{ \App\Helpers\CommonHelper::formatDate($order->orderCancel->created_at, $order->customer?->timezone) }}</b>
                                                </p>
                                            </div>
                                        </div>
                                    @endif
                                    {{-- cancle items received date --}}
                                    @if ($order->orderCancel->items_received_at)
                                        <div class="d-flex">
                                            <div class="col-4">
                                                <p class=""><b>Items received at : </b></p>
                                            </div>
                                            <div class="col-8">
                                                <p class="text-capitalize text-danger">
                                                    <b>&nbsp;&nbsp;{{ \App\Helpers\CommonHelper::formatDate($order->orderCancel->items_received_at, $order->customer?->timezone) }}</b>
                                                </p>
                                            </div>
                                        </div>
                                    @endif
                                    {{-- cancel refund date --}}
                                    @if ($order->orderCancel->refund_at)
                                        <div class="d-flex">
                                            <div class="col-4">
                                                <p class=""><b>Refund at : </b></p>
                                            </div>
                                            <div class="col-8">
                                                <p class="text-capitalize text-danger">
                                                    <b>&nbsp;&nbsp;{{ \App\Helpers\CommonHelper::formatDate($order->orderCancel->refund_at, $order->customer?->timezone) }}</b>
                                                </p>
                                            </div>
                                        </div>
                                    @endif
                                </div>
                            @endif
                        @endcan
                        @can('status-update-order')
                            @if ($order->payment_status == 0)

                                @if ($order->order_status == 0)
                                    <div class="update-status-container">
                                        <div class="update-btns">
                                            {{-- Accept --}}
                                            <x-order.action-form :url="route('admin.orders.update', $order->id)" method="put" :hidden-fields="['order_status' => 1]"
                                                button-text="Accept the Order" button-class="btn btn-success"
                                                icon="fas fa-check-circle" confirm="update-status" />

                                            {{-- Reject --}}
                                            <x-order.action-form :url="route('admin.orders.update', $order->id)" method="put" :hidden-fields="['order_status' => 7]"
                                                button-text="Reject the Order" button-class="btn btn-secondary"
                                                icon="fas fa-times-circle" confirm="update-status" />
                                        </div>

                                    </div>
                                @elseif(in_array($order->order_status, [1]) && $order->transaction?->payment_status == 'pending')
                                    <div class="update-status-container mt-2">
                                        <div class="update-btns">
                                            <form class="row g-3 ajax-submit-form" data-confirm ="update-status"
                                                data-url="{{ route('admin.ordersPayment.update', $order->id) }}"
                                                data-method="post">
                                                @method('put')
                                                <button type="submit" class="btn btn-success">
                                                    <i class="fas fa-check-circle"></i> Mark as Paid
                                                </button>
                                            </form>
                                            {{-- <form class="ajax-submit-form ms-2"
                                                data-url="{{ route('admin.markPaymentFailed', $order->id) }}"
                                                data-method="put" data-confirm="update-status">
                                                <button type="submit" class="btn btn-danger">
                                                    <i class="fas fa-times-circle"></i> Payment Not Received
                                                </button>
                                            </form> --}}
                                        </div>

                                    </div>
                                @endif
                            @elseif ($order->payment_status == 1)
                                @if (in_array($order->order_status, [1, 2]))
                                    <div class="update-status-container">
                                        <form class="row g-3 ajax-submit-form" data-confirm ="update-status"
                                            data-url="{{ route('admin.orders.update', $order->id) }}" data-method="post">
                                            @method('put')

                                            <div class="col-sm-8">

                                                <label for="order_status" class="visually-hidden">Order Status</label>
                                                <select name="order_status" class="form-select" id="order_status">
                                                    <option selected value="">
                                                        {{ orderStatuses($order->order_status) }}</option>
                                                    @foreach (nextOrderStatus($order->order_status) as $key => $value)
                                                        <option {{ $key == $order->order_status ? 'selected' : '' }}
                                                            value="{{ $key }}">
                                                            {{ $value }}</option>
                                                    @endforeach
                                                </select>
                                            </div>
                                            {{-- Cancel reason (hidden by default) --}}
                                            <div class="col-sm-12 mt-2 d-none" id="cancel_reason_box">
                                                <label for="cancel_reason">Cancel Reason <span
                                                        class="text-danger">*</span></label>
                                                <textarea class="form-control" name="cancel_reason" id="cancel_reason" rows="2"></textarea>
                                            </div>
                                            <div class="col-sm-4">
                                                <button type="submit" class="btn btn-primary mb-3">Update</button>
                                            </div>

                                        </form>
                                    </div>


                                    {{-- @if (auth()->user()->hasPermissionTo('approve-order'))
                                    <div class="order-approve-container">
                                        <form class="row g-3 ajax-submit-form" data-confirm ="order-approve"
                                            data-url="{{ route('admin.ordersRefund.update', $order->id) }}" data-method="post">
                                            @method('put')

                                            <input type="hidden" name="mark_as_refunded" value="1">
                                            <button type="submit" class="btn btn-primary mb-3"><i
                                                    class="fas fa-check-circle"></i>
                                                Approve Order</button>

                                        </form>
                                    </div>
                                @endif --}}

                                    {{-- Cancle approve or reject --}}
                                @elseif (in_array($order->order_status, [4]) &&
                                        $order->orderCancel->status == 0 &&
                                        $order->orderCancel->cancel_by_type == CUSTOMER)
                                    <div class="update-status-container">
                                        <div class="update-btns mt-2">
                                            {{-- Accept --}}
                                            <x-order.action-form :url="route(
                                                'admin.orderCancellations.update',
                                                $order->orderCancel->id,
                                            )" method="put" :hidden-fields="['status' => 1, 'refund_status' => 1]"
                                                button-text="Approve Cancel" button-class="btn btn-success"
                                                icon="fas fa-check-circle" confirm="update-status" />
                                            {{-- Reject --}}
                                            <x-order.action-form :url="route(
                                                'admin.orderCancellations.update',
                                                $order->orderCancel->id,
                                            )" method="put" :hidden-fields="['status' => 2]"
                                                button-text="Reject Cancel" button-class="btn btn-secondary"
                                                icon="fas fa-times-circle" confirm="update-status" />

                                        </div>

                                    </div>


                                    {{-- Return approve or reject --}}
                                @elseif (in_array($order->order_status, [5]) && $order->orderReturn->status == 0)
                                    <div class="update-status-container">
                                        <div class="update-btns">
                                            {{-- Accept --}}
                                            <x-order.action-form :url="route('admin.orderReturn.update', $order->orderReturn->id)" method="put" :hidden-fields="['status' => 1, 'refund_status' => 1]"
                                                button-text="Approve Return" button-class="btn btn-success"
                                                icon="fas fa-check-circle" confirm="update-status" />
                                            {{-- Reject --}}
                                            <x-order.action-form :url="route('admin.orderReturn.update', $order->orderReturn->id)" method="put" :hidden-fields="['status' => 2]"
                                                button-text="Reject Return" button-class="btn btn-secondary"
                                                icon="fas fa-times-circle" confirm="update-status" />

                                        </div>

                                    </div>
                                @elseif (in_array($order->order_status, [4, 5, 8, 9]))
                                    {{-- check items recevied --}}
                                    @if (
                                        ($order->orderReturn?->refund_status == 1 && !$order->orderReturn?->items_received) ||
                                            ($order->orderCancel?->refund_status == 1 && !$order->orderCancel?->items_received))
                                        <div class="update-status-container">
                                            <form class="row g-3 ajax-submit-form"
                                                data-url="{{ route('admin.ordersItemsReceived.update', $order->id) }}"
                                                data-method="post">
                                                @method('put')

                                                <input type="hidden" name="items_received" value="1">
                                                <button type="submit" class="mt-4 btn btn-success mb-3"><i
                                                        class="fas fa-check-circle"></i>
                                                    Items Received</button>

                                            </form>
                                        </div>
                                        {{-- Mark refund for orders have pending refund --}}
                                        {{-- @elseif(
                                        ($order->orderReturn?->refund_status == 1 && $order->orderReturn?->items_received) ||
                                            ($order->orderCancel?->refund_status == 1 && $order->orderCancel?->items_received) ||
                                            ($order->order_status == 7 && $order->refund_status == 1)) --}}
                                    @elseif(
                                        ($order->orderReturn?->refund_status == 1 && $order->orderReturn?->items_received) ||
                                            ($order->orderCancel?->refund_status == 1 && $order->orderCancel?->items_received))
                                        <div class="update-status-container">
                                            <form class="row g-3 ajax-submit-form"
                                                data-url="{{ route('admin.ordersRefund.update', $order->id) }}"
                                                data-method="post">
                                                @method('put')

                                                <input type="hidden" name="mark_as_refunded" value="2">
                                                <button type="submit" class="mt-4 btn btn-success mb-3"><i
                                                        class="fas fa-check-circle"></i>
                                                    Mark as Refunded</button>

                                            </form>
                                        </div>
                                    @endif
                                @endif
                            @endif

                        @endcan


                    </div>
                </div>
            </div>
            <div class="col-lg-4 col-sm-6">
                <div class="card px-4 mb-4">
                    <div class="card-body px-0">
                        <h5 class="">Shipping Adress</h5>
                        @if ($order->shippingAddress)
                            <div class="customer-shipping-address">
                                <p class="font-weight text-capitalize"> {{ $order->shippingAddress->full_name }}</p>
                                <p><i class="fas fa-mobile-alt"></i>
                                    {{ $order->shippingAddress->dial_code }} {{ $order->shippingAddress->mobile_number }}
                                </p>
                                <p><i class="fas fa-map-marker-alt"></i> {{ $order->shippingAddress->address }},
                                    {{ $order->shippingAddress->city }},
                                    {{ $order->shippingAddress->state }},
                                    {{ $order->shippingAddress->country }},
                                    {{ $order->shippingAddress->pincode }}
                                </p>



                            </div>
                        @else
                            <p class="font-weight text-capitalize"> Not Available</p>
                        @endif
                        <div class="billing">
                            <h5 class="">Billing Address</h5>


                            <div class="customer-shipping-address">
                                @if ($order->billingAddress)
                                    <p class="font-weight text-capitalize"> {{ $order->billingAddress->full_name }}</p>
                                    <p><i class="fas fa-mobile-alt"></i>
                                        {{ $order->billingAddress->dial_code }}
                                        {{ $order->billingAddress->mobile_number }}
                                    </p>
                                    <p><i class="fas fa-map-marker-alt"></i> {{ $order->billingAddress->address }},
                                        {{ $order->billingAddress->city }},
                                        {{ $order->billingAddress->state }},
                                        {{ $order->billingAddress->country }},
                                        {{ $order->billingAddress->pincode }}
                                    </p>
                                @else
                                    <p class="font-weight text-capitalize"> Not Available</p>
                                @endif



                            </div>
                        </div>

                    </div>
                </div>
            </div>
        </div>
        {{-- <div class="timeline-wrapper">
            <div class="card px-4 mb-4">
                <div class="card-body px-0">
                    <h5 class="mb-3">Shipping Activity</h5>
                    <div class="shipping-activity-container ">
                        @php
                            $logs = $order->orderStatusLogs;
                            $logsByStatus = $logs->keyBy('status');
                            $isRefund = $order->refund_status == 1;
                            $statusToShow = getOrderStatusFlow($logs, $isRefund);
                        @endphp

                        <div class="shipping-activity-container">
                            @foreach ($statusToShow as $loopIndex => $key)
                                @php
                                    $status = orderStatuses($key);
                                    $log = $logsByStatus->get($key);
                                    $isActive = !is_null($log); // Refund is now logged in DB, so just check presence
                                @endphp

                                <div class="timeline-step d-flex align-items-start">

                                    <div
                                        class="timeline-line {{ $isActive ? 'timeline-line-active-color' : 'timeline-line-deactive-color' }}">
                                    </div>

                                    <div class="timeline-icon-wrapper">
                                        <div class="timeline-icon {{ $isActive ? 'bg-primary-c' : 'bg-light-c' }}">
                                        </div>
                                    </div>
                                    <div class="timeline-content ms-3">
                                        <h6 class="mb-1 fw-semibold">{{ $status }}</h6>
                                        @if ($isActive)
                                            <small class="text-muted">{{ dateInList($log->status_date_time) }}</small>
                                        @else
                                            <small class="text-muted">Not yet updated</small>
                                        @endif
                                    </div>
                                </div>
                            @endforeach

                        </div>
                    </div>
                </div>
            </div>
        </div> --}}
        <div class="row ">
            <!-- Basic Layout -->
            <div class="col-md-12 col-sm-12">
                <div class="card px-4 mb-4">
                    <div class="card-body px-0">
                        <h4 class="">Order Detail</h4>
                        {{-- order detail in loop --}}
                        @if (isset($order->orderDetails) && count($order->orderDetails) > 0)
                            <table id="orderTable" class="table table-hover display responsive nowrap">
                                <thead>
                                    <tr>
                                        <th>
                                            #
                                        </th>
                                        <th>
                                            Product Name
                                        </th>
                                        <th>
                                            Price ({{ $order->currency_code }})
                                        </th>

                                        <th>
                                            Quantity
                                        </th>
                                        <th>
                                            Total
                                        </th>
                                        @if (
                                            ($order->order_status == 8 && $order->orderReturn?->items_received == 1) ||
                                                ($order->order_status == 9 && $order->orderCancel?->items_received == 1))
                                            <th>
                                                Update Stock
                                            </th>
                                        @endif
                                    </tr>
                                </thead>

                                <tbody class="table-border-bottom-0">
                                    <form class="row g-3 ajax-submit-form"
                                        data-url="{{ route('admin.orders.updateStock', $order->id) }}"
                                        data-method="post">
                                        @method('put')
                                        @foreach ($order->orderDetails as $item)
                                            <tr>
                                                <td>
                                                    {{ $loop->iteration }}
                                                </td>
                                                <td class="text-capitalize">
                                                    {{ $item->product_name }}
                                                </td>
                                                <td class="text-capitalize">
                                                    {{ $currencySymbol }}
                                                    {{ $item->price }}

                                                </td>
                                                <td class="text-capitalize">
                                                    {{ $item->quantity }}
                                                </td>
                                                <td class="text-capitalize">
                                                    {{ $currencySymbol }}
                                                    {{ $item->total }}
                                                </td>
                                                @if (
                                                    ($order->order_status == 8 && $order->orderReturn?->items_received == 1) ||
                                                        ($order->order_status == 9 && $order->orderCancel?->items_received == 1))
                                                    <td>
                                                        @if ($item->received_qty != $item->quantity)
                                                            {{-- if quantity more than 1 then select box otherwise check box --}}
                                                            @if ($item->quantity > 1)
                                                                <select class="form-select"
                                                                    name="received_qty[{{ $item->id }}]">
                                                                    <option value="">Select</option>
                                                                    @for ($i = 1; $i <= $item->pending_qty; $i++)
                                                                        <option value="{{ $i }}">
                                                                            {{ $i }}
                                                                        </option>
                                                                    @endfor
                                                                </select>
                                                                <small class="text-muted">
                                                                    Already updated : {{ $item->received_qty }},
                                                                    Pending : {{ $item->pending_qty }}
                                                                </small>
                                                            @else
                                                                <div class="form-check">
                                                                    <input type="checkbox"
                                                                        name="received_qty[{{ $item->id }}]"
                                                                        value="1"
                                                                        id="received_qty[{{ $item->id }}]"
                                                                        class="form-check-input">
                                                                    <label class="form-check-label"
                                                                        for="received_qty[{{ $item->id }}]">Received</label>
                                                                </div>
                                                            @endif
                                                        @else
                                                            <span class = "text-success">
                                                                Updated <i class="fas fa-check-circle"></i>
                                                            </span>
                                                        @endif


                                                    </td>
                                                @endif
                                            </tr>
                                        @endforeach
                                        {{-- Button row (aligned with Item Received column) --}}
                                        @php
                                            $hasPending =
                                                $order->orderDetails->where('pending_qty', '>', 0)->count() > 0;
                                        @endphp
                                        @if (
                                            (($order->order_status == 8 && $order->orderReturn?->items_received == 1) ||
                                                ($order->order_status == 9 && $order->orderCancel?->items_received == 1)) &&
                                                $hasPending)
                                            <tr>
                                                {{-- Empty cells to align button with the correct column --}}
                                                <td colspan="5"></td>
                                                <td>
                                                    <button type="submit" class="btn btn-info w-100">
                                                        Update Stock
                                                    </button>
                                                </td>
                                            </tr>
                                        @endif
                                    </form>
                                </tbody>




                            </table>

                        @endif

                        <div class="totalpyment pt-3 d-flex justify-content-end align-items-center m-6 mb-2">
                            <div class="col-md-3 col-sm-12 order-calculations">
                                {{-- <div class="d-flex justify-content-start mb-2">
                                    <span class="w-px-100 text-heading">Subtotal:</span>
                                    <h6 class="mb-0">$2093</h6>
                                </div> --}}

                                {{-- <div class="d-flex justify-content-start mb-2">
                                    <span class="w-px-100 text-heading">Wholesale Discount:</span>
                                    <h6 class="mb-0">N/A</h6>
                                </div> --}}
                                {{-- <div class="d-flex justify-content-start mb-2">
                                    <span class="w-px-100 text-heading">Tax:</span>
                                    <h6 class="mb-0">$28</h6>
                                </div> --}}
                                <div class="total-cal mb-3">
                                    <h6 class=" mb-0">Products Cost:</h6>
                                    <h6 class="mb-0"><b> {{ $currencySymbol }}{{ $order->subtotal }}</b></h6>
                                </div>
                                <div class="total-cal justify-content-start mb-3">
                                    <h6 class=" mb-0">Tax:({{ $order->tax_percent }}%)</h6>
                                    <h6 class="mb-0"><b> {{ $currencySymbol }}{{ $order->tax_amount }}</b></h6>
                                </div>
                                <div class="total-cal justify-content-start">
                                    <h6 class=" mb-0">Total Cost:</h6>
                                    <h6 class="mb-0"><b> {{ $currencySymbol }}{{ $order->total_price }}</b></h6>
                                </div>
                            </div>
                        </div>
                        {{-- display payment proof and notes --}}
                        <div class="extra">
                            <hr>
                            <div class="row">
                                <div class="col-sm-6">
                                    <h5>Notes</h5>
                                    @if ($order->notes)
                                        <p>{{ $order->notes }}</p>
                                    @else
                                        <p>Not Available</p>
                                    @endif

                                </div>
                                <div class="col-sm-6">
                                    @if ($order->transaction?->files->isNotEmpty())
                                        <div class="">
                                            <h5>Payment Proofs</h5>
                                            @foreach ($order->transaction?->files as $file)
                                                <a data-type="image" data-fancybox="gallery"
                                                    href="{{ asset($file->file_path) }}">
                                                    {{-- <img class="media-item" src="{{ asset($banner->media_path) }}" width="80px" /> --}}
                                                    <img class="payment-proof " src="{{ asset($file->file_path) }}"
                                                        alt="payment proof">
                                                </a>
                                            @endforeach
                                        </div>
                                    @endif
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>

        </div>

        <!-- / Content -->
    @endsection
    @section('scripts')
        <script>
            document.addEventListener("DOMContentLoaded", function() {
                const select = document.getElementById("order_status");
                const cancelBox = document.getElementById("cancel_reason_box");
                const cancelReason = document.getElementById("cancel_reason");
                if (select && cancelBox && cancelReason) {

                    select.addEventListener("change", function() {
                        if (this.value == "9") { //cancel id
                            cancelBox.classList.remove("d-none");
                            cancelReason.setAttribute("required", "required");
                        } else {
                            cancelBox.classList.add("d-none");
                            cancelReason.removeAttribute("required");
                            cancelReason.value = "";
                        }
                    });
                }
            });
        </script>
    @endsection
