<table id="myTable" class="dataTable table table-hover display responsive nowrap">
    <thead>
        <tr>

            <th style="width: 50px;">
                <span class="sortable" data-sort="order_number" data-order="asc">
                    Order Number
                    <i id="sort-icon-order_number" class="bx bx-sort"></i>
                </span>
            </th>
            <th>
                <span class="sortable" data-sort="customer_name" data-order="asc">
                    Customer Name
                    <i id="sort-icon-customer_name" class="bx bx-sort"></i>
                </span>
            </th>
            <th>
                <span class="sortable" data-sort="total_price" data-order="asc">
                    Total Amount
                    <i id="sort-icon-total_price" class="bx bx-sort"></i>
                </span>
            </th>

            <th>
                <span class="sortable" data-sort="order_status" data-order="asc">
                    Order Status
                    <i id="sort-icon-order_status" class="bx bx-sort"></i>
                </span>
            </th>
            <th>
                <span class="sortable" data-sort="total_items" data-order="asc">
                    Total Items
                    <i id="sort-icon-total_items" class="bx bx-sort"></i>
                </span>
            </th>
            <th>
                <span class="sortable" data-sort="created_at" data-order="asc">
                    Created at
                    <i id="sort-icon-created_at" class="bx bx-sort"></i>
                </span>

            </th>
            <th>Actions</th>
        </tr>
    </thead>
    @if (isset($orders) && count($orders) > 0)
        <tbody class="table-border-bottom-0">

            @foreach ($orders as $order)
                <tr>

                    <td class="">{{ $order->order_number }}</td>
                    <td class="text-capitalize">{{ $order->customer?->full_name }}</td>
                    <td class="text-capitalize">
                        {{ App\Helpers\CommonHelper::getCurrencyInfo($order->currency_code)->currency_symbol ?? '' }}
                        {{ $order->total_price }}
                        {{ $order->currency_code }}

                    </td>

                    <td class="text-capitalize">
                        <span class="badge {{ App\Helpers\CommonHelper::badgeForOrderStatuses($order->order_status) }}">
                            {{ orderStatuses($order->order_status) }}
                        </span>
                    </td>
                    <td class="">

                        {{ $order->total_items }}

                    </td>
                    <td>{{ \App\Helpers\CommonHelper::formatDate($order->created_at, $order->customer?->timezone) }}
                    </td>
                    <td>
                        @canViewOrderDetail($order)
                        <a class="btn btn-success" href="{{ route('admin.orders.show', $order->id) }}">View</a>
                        @endcanViewOrderDetail
                        {{-- @canany(['view-order-detail-order', 'status-update-order'])
                <a class="btn btn-success" href="{{ route('admin.orders.show', $order->id) }}">View</a>
            @endcanany --}}
                    </td>

                </tr>
            @endforeach
        </tbody>

        <tfoot>
            <tr>
                <td class="" colspan="6">
                    <div class="mt-2 row justify-space-between mb-2">
                        <div class="col-md-6">
                            <div class="" id="records">{!! pageInfo($orders) !!}</div>
                        </div>
                        <div class="col-md-6 pagination-end">

                            {!! $orders->links('pagination::bootstrap-4') !!}

                        </div>
                    </div>
                </td>
            </tr>
        </tfoot>
    @endif
</table>
