@extends('admin.layouts.app')
@section('title', 'Edit Employee')
@section('content')
    <!-- Content -->

    <div class="container-xxl flex-grow-1 container-p-y">
        {{-- <h4 class="fw-bold py-3 mb-4"><span class="text-muted fw-light">Forms/</span> Horizontal Layouts</h4> --}}

        <!-- Basic Layout & Basic with Icons -->
        <div class="row ">
            <!-- Basic Layout -->
            <div class="col-xxl-10 col-lg-10 col-md-12 col-sm-12">
                <div class="card px-4 mb-4">
                    <div class="title-n-btn ">
                        <h4 class="">Edit Employee</h4>

                    </div>
                    <div class="card-body px-0">
                        <form class="ajax-submit-form" data-url="{{ route('admin.employee.update', $employee->id) }}"
                            data-method="POST" enctype="multipart/form-data">
                            @method('PUT')
                            @if ($roles->isNotEmpty())
                                <div class="row mb-3">
                                    <label class="col-sm-2 col-form-label" for="name">Assign Role</label>
                                    <div class="col-sm-10">
                                        <select name="role" id="role" class="form-select">

                                            @foreach ($roles as $role)
                                                <option value="{{ $role->name }}"
                                                    {{ old('role', $employeeRole->contains($role->id)) ? 'selected' : '' }}>
                                                    {{ $role->name }}
                                                </option>
                                            @endforeach
                                        </select>
                                    </div>
                                </div>
                            @endif
                            {{-- Name --}}
                            <div class="row mb-3">
                                <label class="col-sm-2 col-form-label" for="name">Name</label>
                                <div class="col-sm-10">
                                    <input name="name" type="text" class="form-control" id="name"
                                        value="{{ old('name', $employee->name) }}" />
                                </div>
                            </div>

                            {{-- Email --}}
                            <div class="row mb-3">
                                <label class="col-sm-2 col-form-label" for="email">Email</label>
                                <div class="col-sm-10">
                                    <input name="email" type="email" class="form-control" id="email"
                                        value="{{ old('email', $employee->email) }}" />
                                </div>
                            </div>

                            {{-- Mobile Number --}}
                            <div class="row mb-3">
                                <label class="col-sm-2 col-form-label" for="mobile_number">Mobile Number</label>
                                <div class="col-sm-10">
                                    <input name="mobile_number" type="text" class="form-control" id="phone"
                                        value="{{ old('mobile_number', $employee->mobile_number) }}" />
                                    <input type="hidden" name="dial_code" id="dial_code"
                                        value="{{ $employee->dial_code }}">
                                    <input type="hidden" name="dial_code_iso" id="dial_code_iso"
                                        value="{{ $employee->dial_code_iso }}">
                                </div>
                            </div>

                            {{-- DOB --}}
                            <div class="row mb-3">
                                <label class="col-sm-2 col-form-label" for="dob">DOB</label>
                                <div class="col-sm-10">
                                    <input name="dob" type="date" class="form-control" id="dob"
                                        value="{{ old('dob', $employee->dob) }}" />
                                </div>
                            </div>

                            {{-- Gender --}}
                            <div class="row mb-3">
                                <label class="col-sm-2 col-form-label" for="gender">Gender</label>
                                <div class="col-sm-10">
                                    <select class="form-select" name="gender" id="gender">
                                        <option value="">Select</option>
                                        <option value="male"
                                            {{ old('gender', $employee->gender) == 'male' ? 'selected' : '' }}>Male
                                        </option>
                                        <option value="female"
                                            {{ old('gender', $employee->gender) == 'female' ? 'selected' : '' }}>Female
                                        </option>
                                        <option value="other"
                                            {{ old('gender', $employee->gender) == 'other' ? 'selected' : '' }}>Other
                                        </option>
                                    </select>
                                </div>
                            </div>

                            {{-- Address --}}
                            <div class="row mb-3">
                                <label class="col-sm-2 col-form-label" for="address">Address</label>
                                <div class="col-sm-10">
                                    <textarea name="address" class="form-control" id="address" rows="2">{{ old('address', $employee->address) }}</textarea>
                                </div>
                            </div>

                            {{-- Image --}}
                            <div class="row mb-3">
                                <label class="col-sm-2 col-form-label" for="image">Image</label>
                                <div class="col-sm-10">
                                    <input type="file" name="image" class="form-control" id="image">
                                    <div class="old-image">
                                        <h6 class="pt-3">Old Image</h6>
                                        <img width="100" src="{{ asset($employee->image) }}" alt="">
                                    </div>
                                </div>
                            </div>

                            {{-- Password --}}
                            <div class="row mb-3">
                                <label class="col-sm-2 col-form-label" for="password">Password</label>
                                <div class="col-sm-10">
                                    <input name="password" type="password" class="form-control" id="password" />
                                </div>
                            </div>

                            {{-- Confirm Password --}}
                            <div class="row mb-3">
                                <label class="col-sm-2 col-form-label" for="password_confirmation">Confirm
                                    Password</label>
                                <div class="col-sm-10">
                                    <input name="password_confirmation" type="password" class="form-control"
                                        id="password_confirmation" />
                                </div>
                            </div>

                            {{-- Status --}}
                            <div class="row mb-3">
                                <label class="col-sm-2 col-form-label" for="status">Status</label>
                                <div class="col-sm-10">
                                    <select class="form-select" name="status" id="status">
                                        @foreach (CommonStatusesForCrud() as $key => $value)
                                            <option value="{{ $key }}"
                                                {{ old('status', $employee->status) == $key ? 'selected' : '' }}>
                                                {{ $value }}
                                        @endforeach
                                    </select>
                                </div>
                            </div>

                            <div class="row justify-content-end">
                                <div class="col-sm-10">
                                    <button type="submit" class="btn btn-primary">Update</button>
                                </div>
                            </div>
                        </form>
                    </div>
                </div>
            </div>

        </div>
    </div>

    <!-- / Content -->
@endsection
@section('scripts')
    <script>
        let initialCountry = '{{ $employee->dial_code_iso }}'
        flatpickr("#dob", {
            maxDate: new Date().fp_incr(-18 * 365),
            minDate: new Date().fp_incr(-70 * 365),
            dateFormat: "d-m-Y",
        });
    </script>

@endsection
