//dropzone
let galleryFiles = [];
document.addEventListener('DOMContentLoaded', function () {
    const galleryElement = document.querySelector('#gallery-dropzone');
    if (!galleryElement) return;
    Dropzone.autoDiscover = false;
    // intialize dropzone only if element exist
    const galleryDropzone = new Dropzone(galleryElement, {
        url: "#", // prevent auto upload
        autoProcessQueue: false, // don't auto upload
        uploadMultiple: true,
        parallelUploads: 10,
        maxFiles: 50,
        addRemoveLinks: true,
        acceptedFiles: "image/*",
        dictDefaultMessage: "",
    });
    //that message of add imgaes 
    let dzMessage = document.createElement("div");
    dzMessage.classList.add("dz-custom-message");
    dzMessage.innerHTML = "<strong>Click here to add more images</strong>";
    galleryElement.appendChild(dzMessage);
    // ------------------------------------------
    // load existing images - edit module
    // ------------------------------------------
    existingImages.forEach(img => {
        let fileName = img.image.split('/').pop();
        let mockFile = {
            name: fileName,
            size: img.size ?? 0,

        };

        galleryDropzone.emit("addedfile", mockFile);
        galleryDropzone.emit("thumbnail", mockFile, img.url);
        galleryDropzone.emit("complete", mockFile);
        mockFile.existing = true;
        mockFile.serverId = img.id;

        // Block user from uploading preview overlay  
        mockFile.previewElement.classList.add("dz-success", "dz-complete");
        // Fix image preview display
        let imgTag = mockFile.previewElement.querySelector(".dz-image img");
        if (imgTag) {
            imgTag.style.width = "100%";       // fill container
            imgTag.style.height = "100%";
            imgTag.style.objectFit = "cover";
        }
    });
    galleryDropzone.on("addedfile", function (file) {
        if (!file.serverId) {     // new file only
            galleryFiles.push(file);
            file.previewElement.classList.add("dz-success", "dz-complete");
        }
    });

    // remove from array if user deletes
    galleryDropzone.on("removedfile", function (file) {
        // If it's an EXISTING image -> delete via ajax
        if (file.serverId) {
            $.ajax({
                url: "/admin/product/image/" + file.serverId,
                type: "DELETE",
                success: function () {
                    console.log("Deleted image: " + file.serverId);
                }
            });
            return;
        }
        galleryFiles = galleryFiles.filter(f => f !== file);
    });
});
$(document).ready(function () {
    //csrf setup for ajax call
    $.ajaxSetup({
        headers: {
            'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content'),
        }
    });
    let dangerColor = '#ea1c1c';
    $('.select2').select2();
    new DataTable('#myTable', {
        responsive: true,
        info: false,
        ordering: false,
        paging: false,
        bFilter: false, bInfo: false,
        language: {
            emptyTable: "<span class='text-danger'>No records found. </span>"
        },
    });

    //submit form
    function submitAjaxForm($form, data = null) {
        $('.is-invalid').removeClass('is-invalid');
        $('.invalid-feedback').remove();
        let url = $form.data('url');
        let method = $form.data('method') || 'POST';
        let hasFile = $form.attr('enctype') === 'multipart/form-data';
        let $submitBtn = $form.find('[type="submit"]');
        // let data = hasFile ? new FormData($form[0]) : $form.serialize();

        $submitBtn.prop('disabled', true);

        // if data is not passed, create it from form
        if (!data) {
            const hasFile = $form.attr('enctype') === 'multipart/form-data';
            data = hasFile ? new FormData($form[0]) : $form.serialize();
        }
        $.ajax({
            url: url,
            type: method,
            data: data,
            contentType: data instanceof FormData ? false : 'application/x-www-form-urlencoded; charset=UTF-8',
            processData: !(data instanceof FormData),
            success: function (response, textStatus, xhr) {
                if (xhr.status === 200) {
                    $.toast({
                        heading: 'Success',
                        text: response.message,
                        icon: 'success',
                        afterHidden: function () {
                            //$form[0].reset();
                            if (response.extra.redirect) {
                                window.location.href = response.extra.redirect;
                            }
                        },
                    })
                }
                //$form[0].reset();
            },
            error: function (xhr) {
                const res = xhr.responseJSON;
                if (xhr.status === 500) {
                    $.toast({
                        heading: 'Error',
                        text: res.message,
                        showHideTransition: 'fade',
                        icon: 'error',
                        loaderBg: dangerColor,
                    })
                }
                else if (xhr.status === 400) {
                    if (res.message) {
                        $.toast({
                            heading: 'Error',
                            text: res.message,
                            showHideTransition: 'fade',
                            icon: 'error',
                            loaderBg: dangerColor,
                            afterHidden: function () {
                                if (res.extra.redirect) {
                                    window.location.href = res.extra.redirect;
                                }
                            },
                        });
                    }
                    else if (res.errors) {
                        showValidationErrors($form, res.errors);
                    }
                }
            },
            complete: function () {
                $submitBtn.prop('disabled', false);
            }
        });
    }
    $(document).on('submit', '.ajax-submit-form', function (e) {
        e.preventDefault();
        $('.is-invalid').removeClass('is-invalid');
        $('.invalid-feedback').remove();
        const $form = $(this);
        let data = new FormData($form[0]);
        galleryFiles.forEach((file, index) => {
            data.append(`images[${index}]`, file);
        });
        let $orderStatusField = $form.find('[name="order_status"]');
        let orderStatus = $orderStatusField.length ? $orderStatusField.val() : null;

        if ($form.data('confirm') === 'update-status' && $orderStatusField.length && !orderStatus) {
            showValidationErrors($form, {
                order_status: ['The order status field is required.']
            });
            return;
        }
        if ($form.data('confirm') === 'update-status') {
            Swal.fire({
                title: 'Are you sure?',
                text: 'You are about to update.',
                icon: 'warning',
                showCancelButton: true,
                confirmButtonText: 'Yes, update it!',
                cancelButtonText: 'Cancel',
            }).then((result) => {
                if (result.isConfirmed) {
                    submitAjaxForm($form)
                }
            });
        }
        else {
            submitAjaxForm($form, data);
        }


    });
    //show validation errors
    function showValidationErrors($form, errors) {
        $.each(errors, function (field, msgs) {
            // 1) handle images[] errors separately
            if (field === "images" || field.startsWith("images.")) {
                $("#gallery-dropzone")
                    .after('<p class="invalid-feedback d-block text-danger dz-error-msg">'
                        + msgs.join(', ') +
                        '</p>');
                return;
            }
            if (field.startsWith('permissions.')) {
                // Show all permissions.* errors at the bottom of the #permissions container
                $('#permissions').append(
                    '<p class=" checkserror invalid-feedback d-block text-danger">' + msgs.join(', ') + '</p>'
                );
            } else {
                // Regular single field errors
                var fieldElement = $form.find('[name="' + field + '"]');
                if (fieldElement.length === 1) {
                    fieldElement.addClass('is-invalid');
                    fieldElement.parent().append('<p class=" invalid-feedback">' + msgs.join(',') + '</p>');
                } else {
                    // For multi-value fields like name[]
                    var fieldElement1 = $form.find('[name="' + field + '[]"]');
                    if (fieldElement1.length) {

                        let select2 = fieldElement1.next('.select2');
                        if (select2.length) {
                            fieldElement1.addClass('is-invalid');
                            select2.after('<p class=" invalid-feedback d-block text-danger">' + msgs.join(', ') + '</p>');
                        } else {
                            fieldElement1.parents('#' + field).append('<p class="checkserror invalid-feedback d-block text-danger">' + msgs.join(', ') + '</p>');
                        }
                    }
                }
            }
        });
    }
    //delete call
    $(document).on('click', '.delete-btn', function () {
        Swal.fire({
            title: "Are you sure",
            text: "You wont be able to revert this!",
            icon: "warning",
            showCancelButton: true,
            confirmButtonColor: "#d33",
            cancelButtonColor: "#3085d6",
            confirmButtonText: "Yes delete this"
        }).then((result) => {
            if (result.isConfirmed) {
                var url = $(this).data('url');
                $.ajax({
                    url: url,
                    type: 'DELETE',
                    success: function (response, textStatus, xhr) {
                        if (xhr.status === 200) {
                            $.toast({
                                heading: 'Success',
                                text: response.message,
                                icon: 'success',
                                afterHidden: function () {
                                    if (response.extra.redirect) {
                                        window.location.href = response.extra.redirect;
                                    }
                                },
                            })
                        }

                    },
                    error: function (xhr) {
                        var res = xhr.responseJSON;
                        if (xhr.status === 500) {
                            $.toast({
                                heading: 'Error',
                                text: res.message,
                                showHideTransition: 'fade',
                                icon: 'error',
                                loaderBg: dangerColor,
                            })
                        }
                    }
                });
            };
        });
    });
    //fetch paginatiion data
    function fetchData(page = 1, sortBy = '', sortOrder = '') {
        let pageUrl = $('#pageUrl').val();
        let keyword = $('#search').val();
        let perPage = $('#per_page').val();
        let status = $('#status_filter').val();
        let vehicleMake = $('#vehicle_make_filter').val();
        let vehicleType = $('#vehicle_type_filter').val();
        let plansFilter = $('#plans_filter').val();
        let statusFilter = $('#status_filter').val();
        let approvalStatus = $('#approval_status').val();
        let params = {
            page: page,
            sort_by: sortBy,
            sort_order: sortOrder,
            keyword: keyword,
            per_page: perPage,

        };

        if (vehicleMake) params.vehicle_make = vehicleMake;
        if (vehicleType) params.vehicle_type = vehicleType;
        if (plansFilter) params.plans_filter = plansFilter;
        if (status) params.status = status;
        if (statusFilter) params.status_filter = statusFilter;
        if (approvalStatus) params.approval_status = approvalStatus;



        let urlParams = new URLSearchParams(params);


        $.ajax({
            url: `${pageUrl}?${urlParams.toString()}`,
            type: 'get',
            //beforeSend: function () { showLoader(); },
            success: function (response) {
                $('#pagination-table').html(response.data);
                $('#pagination-table').find('.dataTable').DataTable({
                    searching: false,
                    paging: false,
                    ordering: false,
                    info: false,
                    responsive: true,
                    language: {
                        emptyTable: "<span class='text-danger'>No records found</span>"
                    },
                    fnDrawCallback: function (oSettings) {
                        if (oSettings.fnRecordsTotal() === 0) {
                        } else {
                            $("tfoot td").show();
                        }
                    }
                });
                //hideLoader();
                if (sortBy && sortOrder) {
                    $(`.sortable[data-sort="${sortBy}"]`).attr('data-order', sortOrder);
                    updateSortingIcons(sortBy, sortOrder);
                }
                window.history.pushState(null, '', `${pageUrl}?${urlParams.toString()}`);
            }
        });
    }
    function updateSortingIcons(sortBy, sortOrder) {
        // Reset all icons
        $('.sortable i').removeClass('bx-sort-up bx-sort-down').addClass('bx-sort');

        // Update selected column's icon
        let icon = $(`#sort-icon-${sortBy.replace('.', '_')}`);
        icon.removeClass('bx-sort').addClass(sortOrder === 'asc' ? 'bx-sort-up' : 'bx-sort-down');
    }
    $(document).on('click', '.sortable', function () {
        let sortBy = $(this).data('sort');
        let currentOrder = $(this).attr('data-order') || 'asc';
        let newOrder = (currentOrder === 'asc') ? 'desc' : 'asc';


        updateSortingIcons(sortBy, newOrder);
        $(this).attr('data-order', newOrder);
        fetchData(1, sortBy, newOrder);
    });

    $('#applyFilter').click(() => {
        fetchData(1);
        $('#filterPanel').offcanvas('hide');
    });
    $('#search').on('keyup', function () {
        clearTimeout(this.delay);
        this.delay = setTimeout(() => fetchData(1), 500);
    });
    //$('#per_page, #status_filter').on('change', () => fetchData(1));

    $(document).on('click', '.pagination a', function (e) {
        e.preventDefault();
        let page = $(this).attr('href').split('page=')[1];
        fetchData(page);
    });

    $('#clearFilter').click(function () {
        const baseUrl = window.location.origin + window.location.pathname;
        window.history.pushState({}, '', baseUrl);
    });

    $('#vehicle_make').on('change', function () {
        let makeId = $(this).val();
        let vehcleTypeSelectBar = $('#vehicle_type');
        vehcleTypeSelectBar.empty().append('<option value="">--Loading---</option>');
        if (makeId) {
            $.ajax({
                url: '/admin/vehicle-types/by-make/' + makeId,
                type: 'get',
                success: function (response) {
                    vehcleTypeSelectBar.empty();
                    if (response.status) {
                        if (response.data != '') {
                            $.each(response.data, function (index, type) {
                                vehcleTypeSelectBar.append('<option value="' + type.id + '">' + type.name + '</option>');
                            });
                        }
                        else {
                            vehcleTypeSelectBar.append('<option value="">No Type available under this make</option>');
                        }

                    }
                },
                error: function () {
                    vehcleTypeSelectBar.empty().append('<option value="">--Error Loading---');
                }
            });
        }
        else {
            vehcleTypeSelectBar.empty().append('<option value="">Select Vehicle Make First</option>');
        }
    });

    $('.filter-select').on('change', function () {
        let selectedValue = $(this).val();
        let childSelector = $(this).data('child');
        let fetchUrl = $(this).data('url');


        $(childSelector).prop('disabled', true).html('<option>Loading...</option>');
        $('#applyFilter').prop('disabled', true);

        if (!selectedValue) {
            $(childSelector).html('<option value="">Select</option>').prop('disabled', true);
            $('#applyFilter').prop('disabled', false);
            return;
        }

        $.ajax({
            url: fetchUrl,
            type: 'GET',
            data: { parent_id: selectedValue },
            success: function (res) {
                let options = '<option value="">Select</option>';
                $.each(res.data, function (i, item) {
                    options += `<option value="${item.id}">${item.name}</option>`;
                });
                $(childSelector).html(options).prop('disabled', false);
                $('#applyFilter').prop('disabled', false);

            },
            error: function () {
                $(childSelector).html('<option value="">Select</option>').prop('disabled', true);
                $('#applyFilter').prop('disabled', false);
                alert('Failed to load data.');
            }
        });
    });

    $('#assigned_customer').select2('open');

});
Fancybox.bind("[data-fancybox]", {
    Toolbar: true,
    Thumbs: true,
    loop: true,
});
if ($('#phone').length > 0) {
    document.addEventListener("DOMContentLoaded", function () {
        var input = document.querySelector("#phone");
        if (!input) return;
        var iti = window.intlTelInput(input, {
            separateDialCode: true, // Displays country code separately
            // preferredCountries: ["us", "gb", "in"], // Preferred countries at top
            initialCountry: (typeof initialCountry !== 'undefined') ? initialCountry : "in",

            geoIpLookup: function (callback) {
                fetch("https://ipinfo.io?token=YOUR_TOKEN")
                    .then(response => response.json())
                    .then(data => callback(data.country))
                    .catch(() => callback("us"));
            },
        });
        // Set initial dial code & iso right after initialization
        countryData = iti.getSelectedCountryData();
        document.querySelector('#dial_code').value = '+' + countryData.dialCode;
        document.querySelector('#dial_code_iso').value = countryData.iso2;
        // Listen for changes and update hidden inputs
        input.addEventListener("countrychange", function () {
            var countryData = iti.getSelectedCountryData();
            document.querySelector("#dial_code").value = '+' + countryData.dialCode;
            document.querySelector("#dial_code_iso").value = countryData.iso2;
        });
    });
}



flatpickr("#dob", {
    maxDate: new Date().fp_incr(-18 * 365),
    minDate: new Date().fp_incr(-70 * 365),
    dateFormat: "d-m-Y",
});

