<?php

namespace Database\Seeders;

use Illuminate\Database\Console\Seeds\WithoutModelEvents;
use Illuminate\Database\Seeder;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Carbon;

class OrderStatusLogsSeeder extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        $statuses = [
            0 => 'Pending',
            1 => 'Confirmed',
            2 => 'Shipped',
            3 => 'Delivered',
            4 => 'Cancelled',
            5 => 'Returned'
        ];

        // Fetch all order IDs
        $orderIds = DB::table('orders')->pluck('id');

        foreach ($orderIds as $orderId) {
            // Choose a max status index (between 3 to 5 to simulate complete/partial flows)
            $maxIndex = rand(1, 5);

            $now = Carbon::now()->subDays(rand(0, 10));

            for ($i = 0; $i <= $maxIndex; $i++) {
                DB::table('order_status_logs')->insert([
                    'order_id' => $orderId,
                    'status' => $i, // store the numeric key
                    'status_date_time' => $now->addHours(rand(2, 5))
                ]);

                // If cancelled or returned, stop further statuses
                if (in_array($i, [4, 5])) {
                    break;
                }
            }
        }
    }
}
