<?php

namespace App\Models;

// use Illuminate\Contracts\Auth\MustVerifyEmail;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Foundation\Auth\User as Authenticatable;
use Illuminate\Notifications\Notifiable;
use Laravel\Sanctum\HasApiTokens;
use Illuminate\Database\Eloquent\SoftDeletes;
use Spatie\Permission\Traits\HasRoles;
use App\Models\Role;

class User extends Authenticatable
{
    use HasApiTokens, HasFactory, Notifiable;
    use SoftDeletes;
    use HasRoles;

    /**
     * The attributes that are mass assignable.
     *
     * @var array<int, string>
     */
    protected $fillable = [
        'name',
        'email',
        'password',
        'dial_code',
        'dial_code_iso',
        'image',
        'address',
        'description',
        'dob',
        'gender',
        'status',
        'mobile_number',
        'timezone'
    ];

    /**
     * The attributes that should be hidden for serialization.
     *
     * @var array<int, string>
     */
    protected $hidden = [
        'password',
        'remember_token',
    ];

    /**
     * The attributes that should be cast.
     *
     * @var array<string, string>
     */
    protected $casts = [
        'email_verified_at' => 'datetime',
    ];

    /*public function hasPermissionTo($permission, $guardName = null): bool
    {
        if ($this->hasRole(SUPER_ADMIN)) {
            return true; 
        }

        return parent::hasPermissionTo($permission, $guardName);
    } */

    public function hasAnyPermission(...$permissions): bool
    {
        if ($this->hasRole(SUPER_ADMIN)) {
            return true;
        }

        $permissions = is_array($permissions[0]) ? $permissions[0] : $permissions;

        foreach ($permissions as $permission) {
            if ($this->hasPermissionTo($permission)) {
                return true;
            }
        }

        return false;
    }
    //in conversation table assigned to admins
    public function assignedConversation()
    {
        return $this->hasMany(Conversation::class, 'assigned_to');
    }
    protected $appends = ['avatar_url'];
    public function getAvatarUrlAttribute()
    {
        return $this->image ? asset($this->image) : asset(DEFAULT_PATH);
    }
    public function getPaginatedData($request)
    {
        $query = self::with('roles.department')
            ->whereDoesntHave('roles', function ($q) {
                $q->where('name', SUPER_ADMIN);
            });

        $perPage = $request->input('per_page', 10);
        $sortBy = $request->get('sort_by');
        $allowedSortColumns = ['id', 'name', 'status', 'created_at']; // add only valid DB columns here

        // Default to 'users.id' if invalid or empty
        $sortBy = in_array($sortBy, $allowedSortColumns) ? 'users.' . $sortBy : 'users.id';

        $sortOrder = $request->get('sort_order', 'desc');
        $sortOrder = in_array(strtolower($sortOrder), ['asc', 'desc']) ? $sortOrder : 'desc';

        if ($request->has('keyword') && $request->get('keyword') != '') {
            $keyword = $request->keyword;
            $query->where(function ($q) use ($keyword) {
                $q->where('name', 'like', "%$keyword%")
                    ->orWhere('status', 'like', "%$keyword%")
                    ->orWhere('id', 'like', "%$keyword%");
            });
        }

        if ($request->has('status') && $request->get('status') != '') {
            $query->where('status', $request->status);
        }



        return $query->orderBy($sortBy, $sortOrder)->paginate($perPage);
    }
}
