<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Transaction extends Model
{
    use HasFactory;
    protected $table = 'transactions';
    protected $fillable = [
        'order_id',
        'payment_method',
        'transaction_id',
        'amount',
        'txn_datentime',
        'payment_status'
    ];
    public function order()
    {
        return $this->belongsTo(order::class);
    }
    public function files()
    {
        return $this->hasMany(TransactionFile::class);
    }
}
