<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class ProductVehicleCompatibility extends Model
{
    use HasFactory;
    protected $table = 'product_vehicle_compatibility';
    protected $fillable = [
        'product_id',
        'vehicle_model_id',
    ];
    public $timestamps = true;
    public function product()
    {
        return $this->belongsTo(Product::class);
    }
    public function vehicleModel()
    {
        return $this->belongsTo(VehicleModel::class);
    }
}
