<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Message extends Model
{
    use HasFactory;
    protected $table = 'messages';
    protected $fillable = [
        'conversation_id',
        'sender_id',
        'sender_type',
        'message',
        'attachements',
        'is_read'
    ];


    public function conversation()
    {
        return $this->belongsTo(Conversation::class);
    }
    public function sender()
    {
        return $this->morphTo(__FUNCTION__, 'sender_type', 'sender_id')->withTrashed();
        // if ($this->sender_type === \App\Models\Customer::class) {
        //     return $this->belongsTo(Customer::class, 'sender_id');
        // } elseif ($this->sender_type === \App\Models\User::class) {
        //     return $this->belongsTo(User::class, 'sender_id');
        // }
    }
}
