<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;
use Spatie\Permission\Models\Role;

class Department extends Model
{
    use SoftDeletes;
    use HasFactory;
    protected $table = "departments";
    protected $fillable = [
        'name',
    ];
    public $timestamps = false;

    public const ADMIN_ID = 10;
    public const HR_ID = 6;
    public const FINANCE_ID = 7;
    public const LOGISTIC_ID = 8;
    public const SALES_ID = 9;

    public function role()
    {
        return $this->hasOne(Role::class);
    }
}
