<?php

namespace App\Models;

use App\Helpers\CommonHelper;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Support\Facades\Validator;

class CustomerAddress extends Model
{
    use HasFactory;
    protected $table = 'customers_addresses';
    protected $fillable = [
        'customer_id',
        'type',
        'address',
        'city',
        'state',
        'country',
        'pincode',
        'is_default',
        'logistics_name',
        'gate_name',
        'full_name',
        'mobile_number',
        'dial_code'
    ];

    public function customer()
    {
        return $this->belongsTo(Customer::class);
    }
    //validation
    public  static function addressValidation($requests = [], $type = 'store')
    {
        if (($requests['state_id'] ?? '') === '') {
    $requests['state_id'] = null;
}
if (($requests['city_id'] ?? '') === '') {
    $requests['city_id'] = null;
}
        $rules = [
            'address_line1' => 'required|string|max:500',
            'country_id' => 'required|integer|exists:countries,id',
            'state_id' => 'required|integer|exists:states,id',
            'city_id' => 'required|integer|exists:cities,id',
            'is_default' => 'boolean',
            'full_name'     => 'required|string|max:255',
            'mobile_number' => 'required|string|digits_between:6,20',
            'dial_code'     => 'required|string|max:10',
        ];
        //if country mayanmar then pincode checks apply
        $isPincodeOptional = CommonHelper::isPincodeOptional($requests['country_id'] ?? null);
        $rules['pincode'] = ($isPincodeOptional ? 'nullable' : 'required') . '|string|max:20';

        if ($type == 'update') {
            $rules['address_id'] = 'required|integer|exists:customers_addresses,id';
        }
        return Validator($requests, $rules);
    }
}
