<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use App\Models\Customer;
use Illuminate\Database\Eloquent\SoftDeletes;

class Conversation extends Model
{

    use HasFactory;

    protected $fillable = [
        'customer_id',
        'assigned_to',
        'status'
    ];

    public function customer()
    {
        return $this->belongsTo(Customer::class)->withTrashed();
    }
    public function admin()
    {
        return $this->belongsTo(User::class);
    }
    public function messages()
    {
        return $this->hasMany(Message::class);
    }
    public function lastMessage()
    {
        return $this->hasOne(Message::class)->latestOfMany();
    }
}
