<?php

namespace App\Jobs;

use Illuminate\Bus\Queueable;
use Illuminate\Contracts\Queue\ShouldBeUnique;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Foundation\Bus\Dispatchable;
use Illuminate\Queue\InteractsWithQueue;
use Illuminate\Queue\SerializesModels;
use Illuminate\Support\Facades\DB;

class RecomputeProductRatingJob implements ShouldQueue
{
    use Dispatchable, InteractsWithQueue, Queueable, SerializesModels;
    public int $productId;
    /**
     * Create a new job instance.
     *
     * @return void
     */
    public function __construct(int $productId)
    {
        $this->productId = $productId;
    }

    /**
     * Execute the job.
     *
     * @return void
     */
    public function handle()
    {
        //count avarage of ratings of particular product
        $stats =   DB::table('product_reviews')
            ->selectRaw('avg(rating) as avg_rating, count(*) as total')
            ->where('product_id', $this->productId)
            ->where('status', 1)
            ->first();

        //update the product rating and review count in products table
        DB::table('products')
            ->where('id', $this->productId)
            ->update(['rating' => round($stats->avg_rating ?? 0, 2), 'review_count' => $stats->total ?? 0]);
    }
}
