<?php

namespace App\Http\Controllers\Api;

use App\Helpers\CommonHelper;
use App\Helpers\NotificationHelper;
use Illuminate\Support\Facades\DB;

use App\Http\Controllers\Controller;
use App\Models\Transaction;
use App\Models\TransactionFile;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Validator;
use Throwable;

class TrascationController extends Controller
{
    //upload payment proof
    public function uploadPaymentProof(Request $request)
    {
        $customerId = auth()->id();
        $customerName = auth()->user()->full_name;
        DB::beginTransaction();
        $allowedImageExtensions = CommonHelper::allowedImageExtension();
        //$allowedVideoExtensions = CommonHelper::allowedVideoExtension();
        //$allowedExtensions = array_merge($allowedVideoExtensions, $allowedImageExtensions);
        $allowedExtensions = implode(',', $allowedImageExtensions);
        $validation = Validator::make($request->all(), [
            'transaction_id' => 'required|exists:transactions,id',
            'payment_proof' => 'required|file|mimes:' . $allowedExtensions . '|max:5120|min:1',
            //'payment_proof.*' => 'file|',
        ]);
        if ($validation->fails()) {
            return CommonHelper::apiResponse(400, $validation->errors());
        }

        try {
            $transaction = Transaction::with(['order', 'files'])->find($request->transaction_id);
            //check in which cases allowed payment proof
            if ($transaction->order?->order_status != 1) {
                return CommonHelper::apiResponse(400, __('only_confirm_orders'));
            }
            //only at once submit payment proof
            if ($transaction->files()->exists()) {
                return CommonHelper::apiResponse(400, __('payment_proof_already_submitted'));
            }
            // foreach ($request->file('payment_proof') as $transactionFile) {
            $filePath =  CommonHelper::fileUpload($request->file('payment_proof'), CUSTOMER_PAYMENT_PATH);
            TransactionFile::create([
                'transaction_id' => $request->transaction_id,
                'file_path' =>  $filePath
            ]);
            //}
            //------send admin notification------
            $title = __('payment_proof_submit_admin');
            $order_number = $transaction->order->order_number;
            $order_id = $transaction->order->id;
            $message = __('customer_added_payment_proof', ['customer_name' => $customerName, 'order_number' => $order_number]);
            //save notification
            NotificationHelper::saveNotification(
                $customerId,
                CUSTOMER,
                1,
                ADMIN,
                PAYMENT_SCREEN_SHOT,
                $title,
                $message,
                ['order_id' => $order_id]
            );
            //real time notifcation
            event(new \App\Events\AdminNotificationEvent([
                'message' => $message,
                'title'   => $title,
                'order_id' => $order_id,
                'url' => route('admin.orders.index')
            ]));
            DB::commit();
            return CommonHelper::apiResponse(200, __('payment_proof_submitted'));
        } catch (Throwable $e) {
            DB::rollBack();
            return CommonHelper::apiErrorResponse($e);
        }
    }
}
