<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use App\Models\Customer;
use App\Models\order;
use App\Models\Product;
use App\Models\VehicleMake;
use App\Models\VehicleModel;
use App\Models\VehicleType;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;

class DashboardController extends Controller
{

    public function index()
    {
        $vehicleTypesCount = VehicleType::count();
        $vehicleMakesCount = VehicleMake::count();
        $vehicleModelsCount = VehicleModel::count();
        $productsCount = Product::count();
        $customerCount = Customer::count();
        $ordersCount = order::count();
        // Pass the counts to the view
        return view('admin.dashboard.index', compact(
            'vehicleTypesCount',
            'vehicleMakesCount',
            'vehicleModelsCount',
            'productsCount',
            'customerCount',
            'ordersCount'
        ));
    }
}
