<?php

namespace App\Helpers;

use App\Models\Customer;
use App\Models\Notification as NotificationModel;
use Kreait\Firebase\Factory;
use Kreait\Firebase\Messaging\CloudMessage;
use Kreait\Firebase\Messaging\Notification;
use Illuminate\Support\Facades\Log;

class NotificationHelper
{
    public static function saveNotification(
        $senderId,
        $senderType,
        $receiverId,
        $receiverType,
        $type,
        $title,
        $message,
        $data = [],
        $isRead = 0,
    ) {
        $notification = NotificationModel::create([
            'sender_id' => $senderId,
            'sender_type' => $senderType,
            'receiver_id' => $receiverId,
            'receiver_type' => $receiverType,
            'type' => $type,
            'title' => $title,
            'message' => $message,
            'data' => is_array($data) ? json_encode($data) : $data,
            'is_read' => $isRead,
        ]);

        //fecth customer
        if ($receiverType == CUSTOMER) {
            $customer = Customer::find($receiverId);
            if ($customer && $customer->fcm_token) {
                $pushData = array_merge([
                    'notification_id' => $notification->id,
                    'notification_type' => $notification->type,
                    'title' => $notification->title,
                    'message' => $notification->message,
                ], $data);
                self::fcm_notification($customer->fcm_token, $notification->title, $notification->message, $pushData);
            }
        }
        //Log::info('send notification', $notification->toArray());
        return $notification;
    }
    public static function fcm_notification($fcmToken, $title, $message, $data = [])
    {
        //Log::info('start success push');
        $factory = (new Factory)->withServiceAccount(config('services.firebase.credentials'));
        $messaging = $factory->createMessaging();

        $notification = Notification::create($title, $message);

        $message = CloudMessage::withTarget('token', $fcmToken)
            ->withNotification($notification)
            ->withData($data);

        $messaging->send($message);
        Log::info('end success push ', $data);
    }
}
