<?php

namespace App\Helpers;

use App\Models\Department;
use App\Models\Setting;
use Carbon\Carbon;
use GPBMetadata\Google\Rpc\Status;
use Illuminate\Http\UploadedFile;
use Illuminate\Support\Facades\DB;
use function PHPUnit\Framework\fileExists;
use App\Models\CheckoutAddress;
use App\Models\CustomerAddress;
use App\Models\order;


class CommonHelper
{
    public static $basicStatuses = [
        0 => 'Inactive',
        1 => 'Active',
        2 => 'Deleted'
    ];
    public static  $badgesforStatuses = [
        0 => 'bg-warning',
        1 => 'bg-success',
        2 => 'bg-danger',
        3 => 'bg-secondary',
        4 => 'bg-dark',

    ];
    public static $orderSatuses = [
        0 => 'Pending',
        1 => 'Confirmed',
        2 => 'Shipped',
        3 => 'Delivered',
        4 => 'Cancel',
        5 => 'Return',
        6 => 'Partial returned',
        7 => 'Rejected',
        8 => 'Returned',
        9 => 'Cancelled',

    ];
    //common approval statses for cancel and return
    public static $approvalStatuses = [
        0 => 'Pending',
        1 => 'Approved',
        2 => 'Rejected',
    ];
    //payment statuses
    public static $paymentStatuses = [
        0 => 'Unpaid',
        1 => 'Paid',
        2 => 'Refund Initiated',
        3 => 'Refunded',
        4 => 'Failed'
    ];
    // common refund statuses for return & cancel
    public static $refundStatuses = [
        0 => 'Not Refunded',
        1 => 'Refund Pending',
        2 => 'Refunded',
    ];
    //items recived sttauses

    public static $itemsReceivedStatus = [
        0 => 'Items not received',
        1 => 'Items received',
    ];
    public static $badgeForOrderStatuses = [
        0 => 'bg-warning',
        1 => 'bg-primary-d',
        2 => 'bg-info',
        3 => 'bg-success',
        4 => 'bg-danger',
        5 => 'bg-secondary',
        7 => 'bg-danger',
        8 => 'bg-danger',
        9 => 'bg-danger',
    ];
    public static  $badgesforRefundStatuses = [
        0 => 'bg-warning',
        1 => 'bg-danger',
        2 => 'bg-success',
        3 => 'bg-secondary',
        4 => 'bg-dark',
    ];
    public static  $badgesforItemsReceived = [
        0 => 'bg-warning',
        1 => 'bg-success',

    ];
    //past tensed actions
    public static $pastTenseMap = [
        'cancel'  => 'cancel', // or 'canceled' depending on your style
        'pay'     => 'paid',
        'refund'  => 'refunded',
        'return'  => 'return',
        'exchange' => 'exchanged',
    ];
    public static function paymentStatusText($status)
    {
        return self::$paymentStatuses[$status] ?? 'Unknown';
    }
    public static function jsonResponseWeb($statusCode, $message,  $errors = [], $extra = [])
    {
        $response = [
            'message' => $message,
            'errors' => $errors,
            'extra' => $extra,
        ];
        return response()->json($response, $statusCode);
    }
    public static function jsonErrorResponseWeb($e)
    {

        /*if (in_array(env('APP_ENV'), ['local', 'dev'])) {
            return response()->json([
                'status' => false,
                'status_code' => 500,
                'message' => $e->getMessage() . 'on line' . $e->getLine() . 'in' . $e->getFile(),
            ], 500);
        } else {
            return response()->json([
                'status' => false,
                'status_code' => 500,
                'message' => 'Internal Server Error',
            ], 500);
        }*/
        return response()->json([
            'status' => false,
            'status_code' => 500,
            'message' => $e->getMessage() . 'on line' . $e->getLine() . 'in' . $e->getFile(),
        ], 500);
    }
    public static function basicStatusesDisplay($status)
    {
        return self::$basicStatuses[$status] ?? 'unknown';
    }
    public static function badgesforStatuses($status)
    {
        return self::$badgesforStatuses[$status] ?? 'bg-primary';
    }
    public static function  refundBadgeClass($status)
    {
        return self::$badgesforRefundStatuses[$status] ?? 'bg-light';
    }
    public static function itemsReceivedBadges($status)
    {
        return self::$badgesforItemsReceived[$status] ?? 'bg-light';
    }
    public static function fileUpload($name, $path, $oldFile = null)
    {
        if ($oldFile && file_exists(public_path($oldFile))) {
            unlink(public_path($oldFile));
        }
        $imageName = uniqid() . '-' . time() . '.' . $name->getClientOriginalExtension();
        $name->move(public_path($path), $imageName);
        return '/' . trim($path, '/') . '/' . $imageName;
    }
    public static function fetchOrderStatus($status = null)
    {
        if ($status !== null && isset(self::$orderSatuses[$status])) {
            return self::$orderSatuses[$status];
        } elseif ($status !== null) {
            return 'Unknown';
        } else {
            return self::$orderSatuses; // used when you need the full list elsewhere (e.g., dropdown)
        }
    }
    public static function badgeForOrderStatuses($status)
    {
        return self::$badgeForOrderStatuses[$status] ?? 'bg-light text-dark';
    }
    public static function normalizeDepartmentName($name)
    {
        // Convert to lowercase
        $name = strtolower($name);
        $name = str_replace('&', 'and', $name);
        // Remove common suffix like 'department'
        $name = str_replace(['department'], '', $name);

        // Remove special characters like &, -, etc. and replace with space
        $name = preg_replace('/[^a-z0-9\s]/', ' ', $name);

        // Collapse multiple spaces into one
        $name = preg_replace('/\s+/', ' ', $name);

        // Trim spaces
        return trim($name);
    }
    //api error response - internal server error
    public static function apiErrorResponse($e)
    {
        $message = $e->getMessage();
        if (str_contains($message, '250/251/252')) {
            return response()->json(['status' => 400, 'message' => 'Email is invalid', 'data' => (new \stdClass())], 400);
        }
        if (in_array(env('APP_ENV'), ['local'])) {
            return response()->json([
                'status' => false,
                'statusCode' => 500,
                'message' => $e->getMessage(),
                'line' => $e->getLine(),
                'file' => $e->getFile()
            ], 500);
        } else {
            return response()->json([
                'status' => false,
                'statusCode' => 500,
                'message' => 'Internal Server Error'
            ], 500);
        }
    }
    public static function apiResponse($statuscode, $message, $result = [], $messageDescription = '', $isList = false)
    {
        if ($message instanceof \Illuminate\Support\MessageBag) {
            $message = $message->first();
        }

        if ($result instanceof \Illuminate\Support\Collection) {
            $result = $result->toArray();
        }
        if ($isList) {
            $data = !empty($result) ? $result : [];
        } else {

            $data = !empty($result) ? $result : new \stdClass();
        }
        $response = [
            'status' => (int) $statuscode,
            'data' => $data,
            'message' => (string) $message,
            'message_description' => (string) $messageDescription,

        ];


        return response()->json($response, $statuscode);
    }
    public static function  userAccessOrder($user, $order)
    {
        $role = $user->roles->first();
        if (!$role) {
            return false;
        }
        $departmentId = $role->department_id;
        /* if ($role->name === SUPER_ADMIN) {
            return true;
        }*/

        if ($departmentId == Department::LOGISTIC_ID) {
            if ($order->is_approved_by != FINANCE)
                return false;
        }
        return true;
    }
    public static function isFinanceUser($user)
    {
        $role = $user->roles->first();
        return $role && $role->department_id == Department::FINANCE_ID;
    }
    public static function canViewOrderDetail($user, $order)
    {
        return $user &&
            $user->hasAnyPermission(['view-order-detail-order', 'status-update-order']) &&
            self::userAccessOrder($user, $order);
    }
    public static function renderStatusBadges($status)
    {
        return match ($status) {
            ACTIVE => '<span class="badge bg-success">Active</span>',
            DEACTIVE => '<span class="badge bg-danger">Deactive</span>',
            EXPIRED => '<span class="badge bg-secondary">Expired</span>',
            SCHEDULED => '<span class="badge bg-info">Scheduled</span>',
            CANCELLED => '<span class="badge bg-info">Cancelled</span>',
            default => '<span class="badge bg-dark">Unknown</span>',
        };
    }
    public static function renderActionButtons($status)
    {
        return match ($status) {
            ACTIVE =>   '<button class="btn btn-sm btn-warning">Deactivate</button>',
            SCHEDULED => '<button class="btn btn-sm btn-danger">Cancel</button>',
            default => ' <span class="text-muted">--</span>',
        };
    }
    public static function allowedVideoExtension()
    {
        return ['mp4', 'mov', 'avi', 'mkv', 'webm', '3gp', 'flv', 'wmv'];
    }
    public static function allowedImageExtension()
    {
        return ['jpg', 'jpeg', 'webp', 'png', 'gif', 'heic', 'svg'];
    }
    public static function getMultimediaType($fileExtension)
    {
        $fileType = '';
        $imageExtension = self::allowedImageExtension();
        $videoExtension = self::allowedVideoExtension();
        if (in_array($fileExtension, $imageExtension)) {
            return $fileType = 'image';
        } elseif (in_array($fileExtension, $videoExtension)) {
            return $fileType = 'video';
        }
        $fileType;
    }
    public static function base64ToImage($base64String, $uploadPath)
    {
        $image_parts = explode(";base64,", $base64String);
        $image_type_aux = explode("image/", $image_parts[0]);
        $image_type = $image_type_aux[1] ?? 'jpeg';
        $image_base64 = base64_decode($image_parts[1]);
        $fileName = uniqid() . '.' . $image_type;
        $filePath = public_path($uploadPath . '/' . $fileName);
        file_put_contents($filePath, $image_base64);
        return $fileName;
    }
    //get country curreny and timezone
    public static function getCountryInfo(string $dialCodeIso)
    {
        $country =  DB::table('countries')
            ->where('iso2', $dialCodeIso)->select('timezones')
            ->first();

        if ($country && $country->timezones) {
            $timezoneData = json_decode($country->timezones, true);
            $zoneName = $timezoneData[0]['zoneName'] ?? null;
        }

        return [
            'timezone' => $zoneName ?? null,
        ];
    }
    //get symbol currency
    public static function getCurrencyInfo($currencyCode)
    {
        if ($currencyCode == 'RMB') {
            $currencyCode = 'CNY';
        }
        $currecnyInfo =  DB::table('currencies_master')
            ->where('currency_code', strtoupper($currencyCode))
            ->select('currency_code', 'currency_symbol', 'currency_name')->first();
        return $currecnyInfo;
    }
    public static function taxCalculate($amount)
    {
        $taxRate = (float) Setting::getValue('tax');
        $taxAmount = ($amount * $taxRate) / 100;
        return [
            'tax_rate' => $taxRate,
            'tax_amount' => $taxAmount,
            'total_with_tax' => $amount + $taxAmount,

        ];
    }
    public static function getCountries($countryId = null)
    {
        $baseQuery =  DB::table('countries')->select('id', 'name');
        if ($countryId) {
            return $baseQuery->where('id', $countryId)->first();
        }
        return $baseQuery->get();
    }
    public static function getStates($countryId, $stateId = null)
    {
        $baseQuery = DB::table('states')->select('id', 'name');
        if ($countryId && $stateId) {
            return $baseQuery->where('country_id', $countryId)
                ->where('id', $stateId)->first();
        }
        return $baseQuery->where('country_id', $countryId)->get();
    }
    public static function getCities($stateId, $cityId = null)
    {
        $baseQuery = DB::table('cities')->select('id', 'name');
        if ($stateId && $cityId) {
            return $baseQuery->where('state_id', $stateId)
                ->where('id', $cityId)->first();
        }
        return $baseQuery->where('state_id', $stateId)->get();
    }
    public static function getCurrentConversionRate($currencyCode)
    {
        $currrncyRate = Setting::getValue(['usd_to_mmk', 'usd_to_rmb']);
        $currrncyRateMmk = $currrncyRate['usd_to_mmk'] ?? null;
        $currrncyRateRmb = $currrncyRate['usd_to_rmb'] ?? null;
        if ($currrncyRateMmk && $currencyCode === MMK) {
            return $currrncyRateMmk;
        } elseif ($currrncyRateRmb && $currencyCode === RMB || $currencyCode === CNY) {
            return $currrncyRateRmb;
        } elseif ($currencyCode == USD) {
            return "1";
        }
        return 0;
    }
    public static function formatDate($date, $timezone, $withTime = false)
    {
        if (empty($date)) {
            return null;
        }
        $carbonDate = Carbon::parse($date);
        $carbonDate = $carbonDate->setTimezone($timezone ?? 'UTC');
        return $withTime ? $carbonDate->format('d/m/Y H:i:s') : $carbonDate->format('d/m/Y');
    }
    public static $generalNotifyRoles =
    [
        'Super Admin',
    ];
    public static function getReadableTime($timestamp)
    {
        // Ensure $time is a Carbon instance
        $time = $timestamp instanceof Carbon ? $timestamp : Carbon::parse($timestamp);

        //within one munite
        if ($time->diffInSeconds(now()) < 60) {
            return __('just_now');
        }
        //if within last hour ago
        if ($time->diffInMinutes(now()) < 60) {
            return $time->diffInMinutes(now()) . ' min ago';
        }
        //if today
        if ($time->isToday()) {
            return 'Today, ' . $time->format('g:i A');
        }
        //if yesterday
        if ($time->isYesterday()) {
            return 'Yesterday, ' . $time->format('g:i A');
        }
        //if within last week
        if ($time->greaterThanOrEqualTo(now()->startOfWeek())) {
            return $time->format('l g:i A');
        }
        //older than this week
        return $time->format('M d, Y, g:i A');
    }
    //get readable order status for special cases like : retrun/cacnel/reject with refund
    public static function getReadableOrderStatus($order)
    {
        $displayStatus = Self::$orderSatuses[$order->order_status] ?? __('unknown');
        $specialMessage = null;
        $refundStatus = [
            'status' => null,
            'message' => null,
        ];
        //return case
        if (in_array($order->order_status, [5, 8]) && $order->orderReturn) {
            $status = (int) $order->orderReturn->status;
            $refund = (int) $order->orderReturn->refund_status;

            $displayStatus = match ($status) {
                0 => __('return_requested'),
                1 =>  CommonHelper::$orderSatuses[(int)$order->order_status] ?? __('unknown'),
                2 => __('return_rejected'),
                default => null,
            };
            $specialMessage = match ($status) {
                0 => __('return_request_pending'),
                1 => __('return_request_approved'),
                2 => __('return_request_rejected'),
                default => null,
            };
            //refund
            $refundStatus = [
                'status' => self::$refundStatuses[$refund] ?? _('unknown'),
                'message' => match ($refund) {
                    0 => __('not_get_refund'),
                    1 => __('refund_pending'),
                    2 => __('refunded'),
                    default => __('refund_request_unknown'),
                },
            ];
        }
        // ---- CANCEL CASE ----
        elseif (in_array($order->order_status, [4, 9]) && $order->orderCancel) {
            $status = (int)$order->orderCancel->status;
            $refund = (int)$order->orderCancel->refund_status;
            $cancelByType = $order->orderCancel->cancel_by_type ?? null;

            $displayStatus = match ($status) {
                0 => __('cancel_requested'),
                1 => CommonHelper::$orderSatuses[(int)$order->order_status] ?? __('unknown'),
                2 => __('cancel_rejected'),
                default => $displayStatus,
            };

            $specialMessage = match ($status) {
                0 => __('cancel_request_pending'),
                1 => $cancelByType === ADMIN
                    ? __('cancel_request_approved_admin')
                    : __('cancel_request_approved'),
                2 => __('cancel_request_rejected'),
                default => null,
            };

            $refundStatus = [
                'status' => self::$refundStatuses[$refund] ?? __('Unknown'),
                'message' => match ($refund) {
                    0 => __('not_get_refund'),
                    1 => __('refund_pending'),
                    2 => __('refunded'),
                    default => __('refund_request_unknown'),
                },
            ];
        }

        // ---- REJECTED / DIRECT REFUND CASE ----
        elseif ($order->order_status == 7) {
            $refund = (int)$order->refund_status;
            $refundStatus = [
                'status' => self::$refundStatuses[$refund] ?? __('Unknown'),
                'message' => match ($refund) {
                    0 => __('not_get_refund'),
                    1 => __('refund_pending'),
                    2 => __('refunded'),
                    default => __('refund_request_unknown'),
                },
            ];
        }

        // Default (normal order)
        return [
            'display_status' => $displayStatus,
            'special_message' => $specialMessage,
            'refund_status' => $refundStatus,
        ];
    }
    //ready for payment by customer
    public static function readyForPayment($orderStatus, $transactionFile)
    {
        // if ($orderStatus == 1 && $transactionStatus == 'pending') {
        if ($orderStatus == 1 && $transactionFile->isEmpty()) {
            return true;
        }
        return false;
    }
    /**
     * Check if pincode is optional for given country
     *
     * @param int|null $countryId
     * @return bool
     */
    public static function  isPincodeOptional($countryId)
    {
        $optionalPincodeCountryIds = [151]; // maynamar/burma country ids from countries table
        if (in_array((int)$countryId, $optionalPincodeCountryIds)) {
            return true;
        }
        return false;
    }
    //get checkout shipping billing addresses
    public static function getCheckoutAddresses(int $customerId): array
    {
        $countryId = null;
        $stateId = null;
        $cityId = null;
        $customer = auth()->user();
        // fetch saved checkout addresses (temp table)
        $shippingAddress = CheckoutAddress::where('customer_id', $customerId)
            ->where('type', 'shipping')
            ->first();

        $billingAddress = CheckoutAddress::where('customer_id', $customerId)
            ->where('type', 'billing')
            ->first();
        if ($billingAddress) {
            $countryId = $billingAddress->country;
            $stateId = $billingAddress->state;
            $cityId = $billingAddress->city;
        }
        $isSavedShipping = 1;

        //if both empty => not first order
        if (!$shippingAddress && !$billingAddress) {
            $isSavedShipping = 0;
            $shippingAddresses = CustomerAddress::where('customer_id', $customerId)
                ->where('type', 'shipping')
                ->orderBy('id', 'desc')
                ->get();
            $shippingAddress = $shippingAddresses->where('is_default', 1)
                ->first();
            if (!$shippingAddress) {
                $shippingAddress =  $shippingAddresses->first();
            }
            //get billing address
            $order = order::with('billingAddress')->where('customer_id', $customerId)->latest()->first();

            $billingAddress = optional($order)->billingAddress;
            //dd($billingAddress);

            if ($billingAddress && $billingAddress->country) {
                $countryId = DB::table('countries')->where('name', $billingAddress->country)->value('id');
                // Get state ID (filter by country_id to be safe)
                if ($billingAddress->state && $countryId) {
                    $stateId = DB::table('states')
                        ->where('name', $billingAddress->state)
                        ->where('country_id', $countryId)
                        ->value('id');
                }

                // Get city ID (filter by state_id to be safe)
                if ($billingAddress->city && $stateId) {
                    $cityId = DB::table('cities')
                        ->where('name', $billingAddress->city)
                        ->where('state_id', $stateId)
                        ->value('id');
                }
            }
        }
        //billing address is empty means it is same as shipping
        if ($billingAddress == null) {
            $isSavedShipping = 0;
            //dd('here2');
            $billingAddress = $shippingAddress;
            $countryId = $billingAddress->country;
            $stateId = $billingAddress->state;
            $cityId = $billingAddress->city;
            //dd($billingAddress);
        }
        // if ($isSavedShipping) {
        //     CustomerAddress::create([
        //         'customer_id' =>  $customerId,
        //         'type' =>  'shipping',
        //         'address' =>  $shippingAddress->address,
        //         'city' =>  $shippingAddress->city,
        //         'state' =>  $shippingAddress->state,
        //         'country' =>  $shippingAddress->country,
        //         'pincode' =>  $shippingAddress->pincode,
        //         'is_default' =>  1,
        //     ]);
        // }
        // Convert IDs to names
        //dd($shippingAddress->city, $shippingAddress->state);
        $shippingAddressWithNames = [
            'full_name'     => $shippingAddress->full_name ?? $customer->full_name,
            'mobile_number' => $shippingAddress->mobile_number ?? $customer->mobile_number,
            'dial_code'     => $shippingAddress->dial_code ?? $customer->dial_code,
            'address'       => $shippingAddress->address ?? null,
            'country'       => $shippingAddress->country ? self::getCountries($shippingAddress->country)->name : null,
            'state'         => $shippingAddress->state ? self::getStates($shippingAddress->country, $shippingAddress->state)->name : null,
            'city'          => $shippingAddress->city ? self::getCities($shippingAddress->state, $shippingAddress->city)->name : null,
            'pincode'       => $shippingAddress->pincode ?? null,
            'logistics_name' => $shippingAddress->logistics_name ?? null,
            'gate_name' => $shippingAddress->gate_name ?? null,
            'notes' => $shippingAddress->notes ?? null,
        ];

        $billingAddressWithNames = [
            'full_name'     => $billingAddress->full_name ?? $customer->full_name,
            'mobile_number' => $billingAddress->mobile_number ?? $customer->mobile_number,
            'dial_code'     => $billingAddress->dial_code ??  $customer->dial_code,
            'address'       => $billingAddress->address ?? null,
            'country' => is_numeric($billingAddress->country)
                ? self::getCountries($billingAddress->country)->name
                : $billingAddress->country,    // already name
            'state'   => is_numeric($billingAddress->state)
                ? self::getStates($billingAddress->country, $billingAddress->state)->name
                : $billingAddress->state,
            'city'    => is_numeric($billingAddress->city)
                ? self::getCities($billingAddress->state, $billingAddress->city)->name
                : $billingAddress->city,
            'pincode'       => $billingAddress->pincode ?? null,
            'country_id' => $countryId,
            'state_id'   => $stateId,
            'city_id'    => $cityId,
        ];

        return [
            'shipping' => $shippingAddressWithNames,
            'billing'  => $billingAddressWithNames,
        ];
    }
    public static function convertAddressToNames($address, $customer)
    {
        if (!$address) return null;

        return [
            'full_name'     => $address->full_name ?? $customer->full_name,
            'mobile_number' => $address->mobile_number ?? $customer->mobile_number,
            'dial_code'     => $address->dial_code ?? $customer->dial_code,
            'address'       => $address->address,
            'country'       => is_numeric($address->country)
                ? self::getCountries($address->country)->name
                : $address->country,
            'state'         => is_numeric($address->state)
                ? self::getStates($address->country, $address->state)->name
                : $address->state,
            'city'          => is_numeric($address->city)
                ? self::getCities($address->state, $address->city)->name
                : $address->city,
            'pincode'       => $address->pincode,
            'logistics_name' => $address->logistics_name,
            'gate_name'      => $address->gate_name,
            'notes'          => $address->notes,
        ];
    }
}
