<table id="myTable" class="dataTable table table-hover display responsive nowrap">
    <thead>
        <tr>

            <th>
                <span class="sortable" data-sort="name" data-order="asc">
                    Name
                    <i id="sort-icon-name" class="bx bx-sort"></i>
                </span>
            </th>
            <th>

                Assigned Role


            </th>
            <th>

                Assigned Department


            </th>
            <th>
                <span class="sortable" data-sort="status" data-order="asc">
                    Status
                    <i id="sort-icon-status" class="bx bx-sort"></i>
                </span>
            </th>
            <th>
                <span class="sortable" data-sort="created_at" data-order="asc">
                    Created at
                    <i id="sort-icon-created_at" class="bx bx-sort"></i>
                </span>

            </th>
            <th>Actions</th>
        </tr>
    </thead>
    <?php if(isset($employees) && count($employees) > 0): ?>
        <tbody class="table-border-bottom-0">

            <?php $__currentLoopData = $employees; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $employee): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <tr>

                    <td class="text-capitalize"><?php echo e($employee->name); ?></td>
                    <td class="text-capitalize"> <?php echo e($employee->roles->pluck('actual_name')->implode(', ')); ?></td>
                    <td><?php echo e(ucfirst($employee->roles->pluck('department.name')->filter()->implode(', '))); ?></td>


                    <td>
                        <span class="badge <?php echo e(badgesforStatuses($employee->status)); ?>">
                            <?php echo e(basicStatusesDisplay($employee->status)); ?>

                        </span>

                    </td>
                    <td><?php echo e(dateInList($employee->created_at)); ?></td>
                    
                    <td class="<?php echo e(hideAction($employee->status)); ?>">
                        <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->any(['list-employee', 'edit-employee', 'delete-employee'])): ?>
                            <div class="dropdown">
                                <button type="button" class="btn p-0 dropdown-toggle hide-arrow" data-bs-toggle="dropdown">
                                    <i class="bx bx-dots-vertical-rounded"></i>
                                </button>
                                <div class="dropdown-menu">
                                    <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('edit-employee')): ?>
                                        <a class="dropdown-item" href="<?php echo e(route('admin.employee.edit', $employee->id)); ?>"><i
                                                class="bx bx-edit-alt me-1"></i> Edit</a>
                                    <?php endif; ?>
                                    <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('delete-employee')): ?>
                                        <button data-url="<?php echo e(route('admin.employee.destroy', $employee->id)); ?>"
                                            data-id="<?php echo e($employee->id); ?>" type="button" class="dropdown-item delete-btn"
                                            href="javascript:void(0);"><i class="bx bx-trash me-1"></i>
                                            Delete</button>
                                    <?php endif; ?>
                                </div>
                            </div>
                        <?php endif; ?>
                    </td>
                </tr>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </tbody>
        <tfoot>
            <tr>
                <td class="" colspan="6">
                    <div class="mt-2 row justify-space-between mb-2">
                        <div class="col-md-6">
                            <div class="" id="records"><?php echo pageInfo($employees); ?></div>
                        </div>
                        <div class="col-md-6 pagination-end">

                            <?php echo $employees->links('pagination::bootstrap-4'); ?>


                        </div>
                    </div>
                </td>
            </tr>
        </tfoot>

    <?php endif; ?>
</table>
<?php /**PATH /home/intellisensetech/public_html/aaa/resources/views/admin/employee/pagination.blade.php ENDPATH**/ ?>