<table id="myTable" class="dataTable table table-hover display responsive nowrap">
    <thead>
        <tr>

            <th>
                Review

            </th>
            <th>
                <span class="sortable" data-sort="full_name" data-order="asc">
                    Rating
                    <i id="sort-icon-full_name" class="bx bx-sort"></i>
                </span>
            </th>
            <th>Status</th>
            <th>

                Product

            </th>
            <th>

                Customer


            </th>
            <th>
                <span class="sortable" data-sort="created_at" data-order="asc">
                    Submitted Date
                    <i id="sort-icon-created_at" class="bx bx-sort"></i>
                </span>
            </th>

            <th>

                Action


            </th>

        </tr>
    </thead>
    <?php if(isset($reviews) && count($reviews) > 0): ?>
        <tbody class="table-border-bottom-0">

            <?php $__currentLoopData = $reviews; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $review): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <tr>

                    <td><?php echo e($review->review); ?></td>
                    <td><?php echo e($review->rating); ?></td>
                    <td>
                        <span class="badge <?php echo e(\App\Helpers\CommonHelper::$badgesforStatuses[$review->status]); ?>">
                            <?php echo e(\App\Helpers\CommonHelper::$approvalStatuses[$review->status]); ?>

                        </span>

                    </td>
                    <td class="text-capitalize"><?php echo e($review->product->name); ?></td>
                    <td class="text-capitalize"><?php echo e($review->customer?->full_name); ?></td>
                    <td><?php echo e(dateInList($review->created_at)); ?></td>
                    <td>
                        <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->any(['list-customer', 'delete-customer', 'edit-customer'])): ?>
                            <div class="action">
                                <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('view-review')): ?>
                                    <a class="btn btn-info" href="<?php echo e(route('admin.product.review.show', $review->id)); ?>">View <i
                                            class="bx bx-show me-1"></i></a>
                                <?php endif; ?>
                            </div>
                        <?php endif; ?>
                    </td>
                </tr>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </tbody>

        <tfoot>
            <tr>
                <td class="" colspan="6">
                    <div class="mt-2 row justify-space-between mb-2">
                        <div class="col-md-6">
                            
                        </div>
                        <div class="col-md-6 pagination-end">

                            

                        </div>
                    </div>
                </td>
            </tr>
        </tfoot>
    <?php endif; ?>
</table>
<?php /**PATH /home/intellisensetech/public_html/aaa/resources/views/admin/product/review-pagination.blade.php ENDPATH**/ ?>