
<?php $__env->startSection('title', 'Edit Wholesale Discount Plan'); ?>
<?php $__env->startSection('content'); ?>
    <!-- Content -->

    <div class="container-xxl flex-grow-1 container-p-y">
        

        <!-- Basic Layout & Basic with Icons -->
        <div class="row ">
            <!-- Basic Layout -->
            <div class="col-12">
                <div class="card px-4 mb-4">
                    <div class="title-n-btn ">
                        <h4 class="">Edit Wholesale Discount Plan</h4>

                    </div>

                    <div class="card-body px-0">
                        <form class="ajax-submit-form" data-url="<?php echo e(route('admin.wholesale-plan.update', $plan->id)); ?>"
                            data-method="POST" enctype="multipart/form-data">
                            <?php echo method_field('PUT'); ?>

                            <div class="row mb-3">
                                <label class="col-sm-2 col-form-label" for="title">Title</label>
                                <div class="col-sm-10">
                                    <input name="title" type="text" class="form-control" id="title"
                                        value="<?php echo e(old('title', ucfirst($plan->title))); ?>" />
                                </div>
                            </div>

                            

                            <div class="row mb-3">
                                <label class="col-sm-2 col-form-label" for="price">Price</label>
                                <div class="col-sm-3">

                                    <div class="input-group">
                                        <input type="number" step="0.01" min="0" name="price_in_usd"
                                            id="price_in_usd" class="form-control" placeholder="" aria-label="price_in_usd"
                                            aria-describedby="basic-addon13"
                                            value="<?php echo e(old('price_in_usd', $plan->price_in_usd)); ?>" />
                                        <span class="input-group-text" id="basic-addon13">Price in USD</span>
                                    </div>
                                </div>
                                <div class="col-sm-3">
                                    <div class="input-group">
                                        <input type="number" step="0.01" min="0" name="price_in_mmk"
                                            id="price_in_mmk" class="form-control" placeholder="" aria-label="price_in_mmk"
                                            aria-describedby="basic-addon13"
                                            value="<?php echo e(old('price_in_mmk', $plan->price_in_mmk)); ?>" />
                                        <span class="input-group-text" id="basic-addon13">Price in MMK</span>
                                    </div>
                                </div>
                                <div class="col-sm-3">
                                    <div class="input-group">
                                        <span class="input-group-text" id="basic-addon13">RMB</span>
                                        <input type="number" step="0.01" min="0" name="price_in_rmb"
                                            id="price_in_rmb" class="form-control" placeholder="" aria-label="price_in_rmb"
                                            aria-describedby="basic-addon13"
                                            value="<?php echo e(old('price_in_rmb', $plan->price_in_rmb)); ?>" />

                                    </div>
                                </div>

                            </div>


                            <div class="row mb-3">
                                <label class="col-sm-2 col-form-label" for="discount">Discount</label>
                                <div class="col-sm-10">
                                    <div class="input-group">
                                        <input type="number" step="0.01" min="0" name="discount" id="discount"
                                            class="form-control" placeholder="" aria-label="discount"
                                            aria-describedby="basic-addon13"
                                            value="<?php echo e(old('discount', ucfirst($plan->discount))); ?>" />
                                        <span class="input-group-text" id="basic-addon13">%</span>
                                    </div>
                                </div>
                            </div>



                            <div class="row mb-3">
                                <label class="col-sm-2 col-form-label" for="min_order_amt_usd">Minimum Order
                                    Amount</label>
                                <div class="col-sm-3">
                                    <div class="input-group">
                                        <span class="input-group-text">USD</span>
                                        <input type="number" step="0.01" min="0"
                                            value="<?php echo e(old('min_order_amt_usd', $plan->min_order_amt_usd)); ?>"
                                            name="min_order_amt_usd" id="min_order_amt_usd" class="form-control"
                                            placeholder="" />
                                    </div>
                                </div>
                                <div class="col-sm-3">
                                    <div class="input-group">
                                        <span class="input-group-text">MMK</span>
                                        <input type="number" step="0.01" min="0"
                                            value="<?php echo e(old('min_order_amt_mmk', $plan->min_order_amt_mmk)); ?>"
                                            name="min_order_amt_mmk" id="min_order_amt_mmk" class="form-control"
                                            placeholder="" />
                                    </div>
                                </div>
                                <div class="col-sm-3">
                                    <div class="input-group">
                                        <span class="input-group-text">RMB</span>
                                        <input type="number" step="0.01" min="0"
                                            value="<?php echo e(old('min_order_amt_rmb', $plan->min_order_amt_rmb)); ?>"
                                            name="min_order_amt_rmb" id="min_order_amt_rmb" class="form-control"
                                            placeholder="" />
                                    </div>
                                </div>
                            </div>

                            <div class="row mb-3">
                                <label class="col-sm-2 col-form-label" for="status">Status</label>
                                <div class="col-sm-10">
                                    <select class="select2" name="status" id="status">
                                        <?php $__currentLoopData = CommonStatusesForCrud(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $value): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <option <?php echo e(old('status', $plan->status) == $key ? 'selected' : ''); ?>

                                                value="<?php echo e($key); ?>"><?php echo e($value); ?></option>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>


                                    </select>

                                </div>
                            </div>

                            <div class="row justify-content-end">
                                <div class="col-sm-10">
                                    <button type="submit" class="btn btn-primary">Update</button>
                                </div>
                            </div>
                        </form>
                    </div>
                </div>
            </div>

        </div>
    </div>

    <!-- / Content -->
<?php $__env->stopSection(); ?>
<?php $__env->startSection('scripts'); ?>
    <script>
        function syncCurrencyFields(baseCurrency, value, rates, fields) {
            let usd = 0,
                mmk = 0,
                rmb = 0;

            if (isNaN(value)) {
                fields.usd.val('');
                fields.mmk.val('');
                fields.rmb.val('');
                return;
            }

            if (baseCurrency === 'usd') {
                usd = value;
                mmk = (usd * rates.usdToMmk).toFixed(2);
                rmb = (usd * rates.usdToRmb).toFixed(2);
            } else if (baseCurrency === 'mmk') {
                mmk = value;
                usd = (mmk / rates.usdToMmk).toFixed(2);
                rmb = (usd * rates.usdToRmb).toFixed(2);
            } else if (baseCurrency === 'rmb') {
                rmb = value;
                usd = (rmb / rates.usdToRmb).toFixed(2);
                mmk = (usd * rates.usdToMmk).toFixed(2);
            }

            fields.usd.val(usd);
            fields.mmk.val(mmk);
            fields.rmb.val(rmb);
        }
        const rates = {
            usdToMmk: <?php echo e($currrncyRateMmk ?? 0); ?>,
            usdToRmb: <?php echo e($currrncyRateRmb ?? 0); ?>

        };
        // PRICE
        $('#price_in_usd').on('input', function() {
            syncCurrencyFields('usd', parseFloat($(this).val()), rates, {
                usd: $('#price_in_usd'),
                mmk: $('#price_in_mmk'),
                rmb: $('#price_in_rmb')
            });
        });

        $('#price_in_mmk').on('input', function() {
            syncCurrencyFields('mmk', parseFloat($(this).val()), rates, {
                usd: $('#price_in_usd'),
                mmk: $('#price_in_mmk'),
                rmb: $('#price_in_rmb')
            });
        });

        $('#price_in_rmb').on('input', function() {
            syncCurrencyFields('rmb', parseFloat($(this).val()), rates, {
                usd: $('#price_in_usd'),
                mmk: $('#price_in_mmk'),
                rmb: $('#price_in_rmb')
            });
        });


        // MIN ORDER AMOUNT
        $('#min_order_amt_usd').on('input', function() {
            syncCurrencyFields('usd', parseFloat($(this).val()), rates, {
                usd: $('#min_order_amt_usd'),
                mmk: $('#min_order_amt_mmk'),
                rmb: $('#min_order_amt_rmb')
            });
        });

        $('#min_order_amt_mmk').on('input', function() {
            syncCurrencyFields('mmk', parseFloat($(this).val()), rates, {
                usd: $('#min_order_amt_usd'),
                mmk: $('#min_order_amt_mmk'),
                rmb: $('#min_order_amt_rmb')
            });
        });

        $('#min_order_amt_rmb').on('input', function() {
            syncCurrencyFields('rmb', parseFloat($(this).val()), rates, {
                usd: $('#min_order_amt_usd'),
                mmk: $('#min_order_amt_mmk'),
                rmb: $('#min_order_amt_rmb')
            });
        });
    </script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('admin.layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/intellisensetech/public_html/aaa/resources/views/admin/wholesleId/edit.blade.php ENDPATH**/ ?>