
<?php $__env->startSection('title', 'Vehicle Make List'); ?>
<?php $__env->startSection('content'); ?>
    <!-- Content -->

    <div class="container-xxl flex-grow-1 container-p-y">

        <div class="card px-4">
            <div class="title-n-btn ">
                <h4 class="">Vehicle Makes</h4>
                <div class="search-flex mt-2">
                    <div class="d-flex col-12">
                        <div class="input-group input-group-merge mx-2">
                            <span class="input-group-text" id="basic-addon-search31"><i class="bx bx-search"></i></span>
                            <input type="text" id="search" class="form-control" placeholder="Search..."
                                aria-label="Search..." aria-describedby="basic-addon-search31" />
                        </div>
                        <button type="button" class="btn btn-info" data-bs-toggle="offcanvas" href="#filterPanel"
                            role="button" aria-controls="filterPanel">
                            <i class="fas fa-filter"></i>
                        </button>
                        
                        <div class="offcanvas offcanvas-end" tabindex="-1" id="filterPanel" aria-labelledby="filterPanel"
                            aria-modal="true" role="dialog">
                            
                            <div class="offcanvas-header border-bottom">
                                <h5 class="offcanvas-title text-uppercase" id="offcanvasRightLabel">
                                    Apply Filter
                                </h5>
                                <button type="button" class="btn-close text-reset" data-bs-dismiss="offcanvas"
                                    aria-label="Close"></button>
                            </div>

                            <div class="offcanvas-body p-0" id="form-filter">
                                <div class="acitivity-timeline p-4">
                                    <div class="row">
                                        <div class="col-md-12 mb-3">
                                            <label class="form-label">Per Page</label>
                                            <select id="per_page" name="" class="form-select w-100">
                                                <?php $__currentLoopData = perPage(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $value): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                    <option value="<?php echo e($key); ?>"><?php echo e($value); ?></option>
                                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                            </select>
                                        </div>



                                        <div class="col-md-12 mb-3">
                                            <label class="form-label">Status</label>
                                            <select id="status_filter" class="form-select w-100 " name="status">
                                                <option value="">Select</option>
                                                <?php $__currentLoopData = CommonStatuses(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $value): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                    <option value="<?php echo e($key); ?>">
                                                        <?php echo e($value); ?></option>
                                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                            </select>
                                        </div>

                                        <div class="col-md-12 mb-3">
                                            <label class="form-label">Vehicle Type</label>
                                            <select id="vehicle_type_filter" class="form-select w-100 " name="vehicle_type">
                                                <option value="">Select</option>
                                                <?php $__currentLoopData = $vehicleTypes; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $vehicleType): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                    <option value="<?php echo e($vehicleType->id); ?>">
                                                        <?php echo e($vehicleType->name); ?></option>
                                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                            </select>
                                        </div>
                                        <div class="col-md-12 mt-2">
                                            <button id="applyFilter" type="submit"
                                                class="filter-btn btn btn-info btn-border me-1">
                                                <i class="bx bx-check"></i>Apply Filter</button>
                                            </button>
                                            <a id="clearFilter" href="" class="btn btn-outline-secondary mt-2">
                                                <i class="bx bx-refresh"></i> Clear
                                            </a>
                                        </div>
                                    </div>

                                </div>
                            </div>
                        </div>
                    </div>

                </div>
            </div>



            <input type="hidden" id="pageUrl" value="<?php echo e(route('admin.vehicle-make.index')); ?>">
            <div class="row">
                <div class="col-md-12">
                    <div id="pagination-table">
                        <?php echo $__env->make('admin.vehicleMake.pagination', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                    </div>
                </div>
            </div>
        </div>

    </div>

    <!-- / Content -->
<?php $__env->stopSection(); ?>

<?php echo $__env->make('admin.layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/intellisensetech/public_html/aaa/resources/views/admin/vehicleMake/index.blade.php ENDPATH**/ ?>