@extends('admin.layouts.app')
@section('title', 'Create Vehicle Make')
@section('content')
    <!-- Content -->

    <div class="container-xxl flex-grow-1 container-p-y">
        {{-- <h4 class="fw-bold py-3 mb-4"><span class="text-muted fw-light">Forms/</span> Horizontal Layouts</h4> --}}

        <!-- Basic Layout & Basic with Icons -->
        <div class="row ">
            <!-- Basic Layout -->
            <div class="col-xxl-8 col-lg-8 col-md-10 col-sm-12">
                <div class="card px-4 mb-4">
                    <div class="title-n-btn ">
                        <h4 class="">Create Vehicle Make</h4>

                    </div>

                    <div class="card-body px-0">
                        <form class="ajax-submit-form" data-url="{{ route('admin.vehicle-make.store') }}" data-method="POST"
                            enctype="multipart/form-data">


                            <div class="row mb-3">
                                <label class="col-sm-2 col-form-label" for="basic-default-name">Name</label>
                                <div class="col-sm-10">
                                    <input name="name" type="text" class="form-control" id="basic-default-name" />
                                </div>
                            </div>
                            <div class="row mb-3">
                                <label class="col-sm-2 col-form-label" for="basic-default-name">Image</label>
                                <div class="col-sm-10">
                                    <input type="file" name="image" class="form-control" id="">

                                </div>
                            </div>


                            <div class="row mb-3">
                                <label class="col-sm-2 col-form-label" for="status">Status</label>
                                <div class="col-sm-10">
                                    <select class="select2" name="status" id="status">
                                        @foreach (CommonStatusesForCrud() as $key => $value)
                                            <option value="{{ $key }}">{{ $value }}</option>
                                        @endforeach


                                    </select>

                                </div>
                            </div>
                            <div class="row mb-3">
                                <label class="col-sm-2 col-form-label" for="basic-default-name">Vehicle Type</label>
                                <div class="col-sm-10">
                                    <div class="row" id="vehicle_types">
                                        @forelse ($vehicleTypes as $vehicleType)
                                            <div class="col-lg-3 col-md-6 col-sm-12">
                                                <div class="form-check">
                                                    <input class="form-check-input" type="checkbox" name="vehicle_types[]"
                                                        value="{{ $vehicleType->id }}"
                                                        id="vehicle_type_{{ $vehicleType->id }}">
                                                    <label class="form-check-label"
                                                        for="vehicle_type_{{ $vehicleType->id }}">
                                                        {{ ucfirst($vehicleType->name) }}
                                                    </label>
                                                </div>
                                            </div>
                                        @empty
                                        @endforelse

                                    </div>
                                </div>
                            </div>

                            <div class="row justify-content-end">
                                <div class="col-sm-10">
                                    <button type="submit" class="btn btn-primary">Create</button>
                                </div>
                            </div>
                        </form>
                    </div>
                </div>
            </div>

        </div>
    </div>

    <!-- / Content -->
@endsection
