@extends('admin.layouts.app')
@section('title', 'Edit Roles')
@section('content')
    <div class="content-wrapper">
        <!-- Content -->
        <div class="row m-3">
            <div class="col-lg-12">
                <div class="card">


                    <div class="card-body">
                        <div class="mt-2 d-flex justify-content-between align-items-center pb-2">
                            <h3 class=" text-dark">Edit Role</h3>

                        </div>
                        <div class="row mt-4">
                            <div class="col-lg-12">
                                <form class="ajax-submit-form" data-url="{{ route('admin.role.update', $role->id) }}"
                                    data-method="POST" enctype="multipart/form-data">
                                    @method('PUT')
                                    <input type="hidden" name="_method" value="PUT">
                                    <div class="row mb-3 justify-content-end ">
                                        <div class="col-md-2  mt-1">
                                            <label for="" class="form-label">Select Department</label>
                                        </div>

                                        <div class="col-md-10">
                                            <select name="department_id" id="department_id" class="form-select">
                                                <option value="">Select Department</option>
                                                @foreach ($departments as $department)
                                                    <option value="{{ $department->id }}"
                                                        {{ old('department_id', $role->department->id ?? '') == $department->id ? 'selected' : '' }}>
                                                        {{ ucfirst($department->name) }}
                                                    </option>
                                                @endforeach
                                            </select>


                                        </div>
                                    </div>
                                    <div class="row mb-3 justify-content-end ">
                                        <div class="col-md-2  mt-1">
                                            <label for="" class="form-label">Role Name</label>
                                        </div>

                                        <div class="col-md-10">

                                            <input class="form-control " type="text" name="name"
                                                value="{{ old('name', $role->name) }}" id="name">

                                        </div>
                                    </div>




                                    {{-- display permissions --}}
                                    <div class="container">
                                        <h6 class="txt-blck">Permissions</h6>
                                        <hr>
                                        <div class="row mt-2" id="permissions">
                                            @if (!empty($permissions))
                                                @php
                                                    $defaultPermissions = config(
                                                        "role_defaults.{$role->department->id}",
                                                    );
                                                @endphp
                                                @foreach ($permissions as $module => $modulePermissions)
                                                    <div class="col-2 mt-4 ">
                                                        <label
                                                            class="text-dark text-capitalize me-3">{{ $module }}:</label>
                                                    </div>
                                                    <div class="row">
                                                        @foreach ($modulePermissions as $permission)
                                                            <div class="col-3 pt-2">
                                                                <input class="form-check-input" type="checkbox"
                                                                    name="permissions[]" value="{{ $permission->name }}"
                                                                    id="perm_{{ $permission->id }}"
                                                                    {{ in_array($permission->name, $defaultPermissions ?? []) || $hasPermissions->contains($permission->name) ? 'checked' : '' }}
                                                                    {{ in_array($permission->name, $defaultPermissions ?? []) ? 'disabled' : '' }}>
                                                                <label class="form-check-label text-capitalize"
                                                                    for="perm_{{ $permission->id }}">
                                                                    {{ $permission->name }}
                                                                </label>
                                                                {{-- hidden checks submitted --}}
                                                                @if (in_array($permission->name, $defaultPermissions ?? []))
                                                                    <input type="hidden" name="permissions[]"
                                                                        value="{{ $permission->name }}">
                                                                @endif
                                                            </div>
                                                        @endforeach

                                                    </div>
                                                @endforeach
                                            @endif
                                        </div>
                                    </div>


                                    <div class="row mt-4 mb-2">
                                        <div class="">
                                            <button type="submit" class="btn btn-primary">
                                                <i class="bx bx-check"></i> Update
                                            </button>
                                        </div>
                                    </div>

                                </form>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <!-- / Content -->



@endsection
@section('scripts')
    <script>
        document.addEventListener("DOMContentLoaded", function() {
            const viewDetail = document.querySelector("#perm_70");
            const ongoingList = document.querySelector("#perm_21");
            if (viewDetail && ongoingList) {
                viewDetail.addEventListener('change', function() {
                    if (this.checked) {
                        ongoingList.checked = true;
                    }
                });
            }
        });
    </script>
@endsection
