@extends('admin.layouts.app')
@section('title', 'Manage Inventory')
@section('content')
    <!-- Content -->

    <div class="container-xxl flex-grow-1 container-p-y">
        {{-- <h4 class="fw-bold py-3 mb-4"><span class="text-muted fw-light">Forms/</span> Horizontal Layouts</h4> --}}

        <!-- Basic Layout & Basic with Icons -->
        <div class="row ">
            <!-- Basic Layout -->
            <div class="col-xxl-10 col-lg-10 col-md-12 col-sm-12">
                <div class="card px-4 mb-4">
                    <div class="title-n-btn ">
                        <h4 class="">Manage Inventory</h4>

                    </div>

                    <div class="card-body px-0">
                        <form class="ajax-submit-form"
                            data-url="{{ route('admin.product.manageInventory.updateInventory', $product->id) }}"
                            data-method="POST" enctype="multipart/form-data">


                            <div class="row mb-3">
                                <label class="col-sm-2 col-form-label" for="status"></label>
                                <div class="col-sm-10">
                                    <h5 class="text-capitalize">{{ $product->name }}</h5>

                                </div>
                            </div>
                            <div class="row mb-3">
                                <label class="col-sm-2 col-form-label" for="type">In or Out</label>
                                <div class="col-sm-10">
                                    <select class="select2" name="type" id="type">

                                        <option value="in">In</option>
                                        <option value="out">Out</option>



                                    </select>

                                </div>
                            </div>

                            <div class="row mb-3">
                                <label class="col-sm-2 col-form-label" for="quantity">Quantity</label>
                                <div class="col-sm-10">
                                    <input min="1" type="number" name="quantity" id="quantity"
                                        class="form-control">


                                </div>
                            </div>


                            <div class="row mb-3">
                                <label class="col-sm-2 col-form-label" for="basic-default-name">Comment</label>
                                <div class="col-sm-10">
                                    <textarea name="comment" id="comment" class="form-control" rows="2"></textarea>

                                </div>
                            </div>


                            <div class="row justify-content-end">
                                <div class="col-sm-10">
                                    <button type="submit" class="btn btn-primary">Save</button>
                                </div>
                            </div>
                        </form>
                    </div>
                </div>
            </div>

        </div>
    </div>

    <!-- / Content -->
@endsection
@section('scripts')
    <script>
        const usdToMmkRate = {{ $currrncyRate ?? 0 }}
        // When typing in USD field
        $('#price_in_usd').on('input', function() {
            let usd = parseFloat($(this).val());
            if (!isNaN(usd)) {
                let mmk = (usd * usdToMmkRate).toFixed(2);
                $('#price_in_mmk').val(mmk);
            } else {
                $('#price_in_mmk').val('');
            }
        });

        // When typing in MMK field
        $('#price_in_mmk').on('input', function() {
            let mmk = parseFloat($(this).val());
            if (!isNaN(mmk)) {
                let usd = (mmk / usdToMmkRate).toFixed(2);
                $('#price_in_usd').val(usd);
            } else {
                $('#price_in_usd').val('');
            }
        });
    </script>
@endsection
