<!DOCTYPE html>
<html lang="en" class="light-style layout-menu-fixed" dir="ltr" data-theme="theme-default"
    data-assets-path="../assets/" data-template="vertical-menu-template-free">

<head>
    <meta charset="utf-8" />
    <meta name="viewport"
        content="width=device-width, initial-scale=1.0, user-scalable=no, minimum-scale=1.0, maximum-scale=1.0" />

    <title>@yield('title') - AAA Auto Mobiles</title>

    <meta name="description" content="" />

    <!-- Favicon -->
    <link rel="icon" type="image/x-icon" href="{{ asset('assets/img/favicon.png') }}" />

    <!-- Fonts -->
    <link rel="preconnect" href="https://fonts.googleapis.com" />
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin />
    <link
        href="https://fonts.googleapis.com/css2?family=Public+Sans:ital,wght@0,300;0,400;0,500;0,600;0,700;1,300;1,400;1,500;1,600;1,700&display=swap"
        rel="stylesheet" />
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/5.15.4/css/all.min.css">


    <!-- Icons. Uncomment required icon fonts -->
    <link rel="stylesheet" href="{{ asset('assets/vendor/fonts/boxicons.css') }}" />

    <!-- Core CSS -->
    <link rel="stylesheet" href="{{ asset('assets/css/custom.css') }}">
    <link rel="stylesheet" href="{{ asset('assets/vendor/css/core.css') }}" class="template-customizer-core-css" />
    <link rel="stylesheet" href="{{ asset('assets/vendor/css/theme-default.css') }}"
        class="template-customizer-theme-css" />
    <link rel="stylesheet" href="{{ asset('assets/css/demo.css') }}" />
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/intl-tel-input/17.0.19/css/intlTelInput.css">

    <!-- Vendors CSS -->
    <link rel="stylesheet" href="{{ asset('assets/vendor/libs/perfect-scrollbar/perfect-scrollbar.css') }}" />

    <link rel="stylesheet" href="{{ asset('assets/vendor/libs/apex-charts/apex-charts.css') }}" />
    <link href="https://cdn.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/css/select2.min.css" rel="stylesheet" />
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/jquery-toast-plugin/1.3.2/jquery.toast.css" />
    <meta name="csrf-token" content="{{ csrf_token() }}">
    <link rel="stylesheet" href="https://cdn.datatables.net/2.2.2/css/dataTables.dataTables.css" />
    <link rel="stylesheet" href="https://cdn.datatables.net/responsive/3.0.4/css/responsive.dataTables.min.css" />
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/flatpickr/dist/flatpickr.min.css">
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/@fancyapps/ui@5.0/dist/fancybox/fancybox.css" />


    <!-- Page CSS -->

    <!-- Helpers -->
    <script src="{{ asset('assets/vendor/js/helpers.js') }}"></script>

    <!--! Template customizer & Theme config files MUST be included after core stylesheets and helpers.js in the <head> section -->
    <!--? Config:  Mandatory theme config file contain global vars & default theme options, Set your preferred theme option in this file.  -->
    <script src="{{ asset('assets/js/config.js') }}"></script>
</head>

<body>
    <!-- Layout wrapper -->
    <div class="layout-wrapper layout-content-navbar">
        <div class="layout-container">
            <!-- Menu -->

            <aside id="layout-menu" class="layout-menu menu-vertical menu bg-menu-theme">
                <div class="logo-admin">
                    <a href="{{ route('admin.dashboard') }}" class="">

                        <img src="{{ asset('assets/img/logo.png') }}" alt="">



                    </a>
                </div>
                <div>
                    <a href="javascript:void(0);"
                        class="layout-menu-toggle menu-link text-large ms-auto d-block d-xl-none">
                        <i class="bx bx-chevron-left bx-sm align-middle"></i>
                    </a>
                </div>

                <div class="menu-inner-shadow"></div>

                <ul class="menu-inner py-1">
                    <!-- Dashboard -->
                    <li class="menu-item {{ Route::is('admin.dashboard') ? 'active' : '' }}">
                        <a href="{{ route('admin.dashboard') }}" class="menu-link">
                            <i class="menu-icon tf-icons bx bx-home-circle"></i>
                            <div data-i18n="Analytics">Dashboard</div>
                        </a>
                    </li>
                    @canany(['add-vehicle_type', 'list-vehicle_type', 'edit-vehicle_type', 'delete-vehicle_type',
                        'add-vehicle_make', 'list-vehicle_make', 'edit-vehicle_make', 'delete-vehicle_make',
                        'add-vehicle_model', 'list-vehicle_model', 'edit-vehicle_model', 'delete-vehicle_model'])
                        <li class="menu-header small text-uppercase">
                            <span class="menu-header-text">Vehicle Management</span>
                        </li>
                        @canany(['add-vehicle_type', 'delete-vehicle_type', 'edit-vehicle_type', 'list-vehicle_type'])
                            <li class="menu-item {{ Route::is('admin.vehicle-type.*') ? 'open active' : '' }}">
                                <a href="javascript:void(0);" class="menu-link menu-toggle">
                                    <i class="menu-icon tf-icons fas fa-truck-pickup"></i>
                                    {{-- <i class="menu-icon tf-icons bx bx-layout"></i> --}}
                                    <div data-i18n="Layouts">Vehicle Type</div>
                                </a>

                                <ul class="menu-sub">
                                    @canany(['list-vehicle_type', 'edit-vehicle_type', 'delete-vehicle_type'])
                                        <li class="menu-item {{ Route::is('admin.vehicle-type.index') ? 'active' : '' }}">
                                            <a href="{{ route('admin.vehicle-type.index') }}" class="menu-link">
                                                <div data-i18n="Without menu">List</div>
                                            </a>
                                        </li>
                                    @endcanany
                                    @can('add-vehicle_type')
                                        <li class="menu-item {{ Route::is('admin.vehicle-type.create') ? 'active' : '' }}">
                                            <a href="{{ route('admin.vehicle-type.create') }}" class="menu-link">
                                                <div data-i18n="Without navbar">Add</div>
                                            </a>
                                        </li>
                                    @endcan
                                </ul>
                            </li>
                        @endcanany
                        @canany(['add-vehicle_make', 'list-vehicle_make', 'edit-vehicle_make', 'delete-vehicle_make'])
                            <li class="menu-item {{ Route::is('admin.vehicle-make.*') ? 'open active' : '' }}">
                                <a href="javascript:void(0);" class="menu-link menu-toggle">
                                    <i class="menu-icon tf-icons fas fa-copyright"></i>
                                    {{-- <i class="menu-icon tf-icons bx bx-layout"></i> --}}
                                    <div data-i18n="Layouts">Vehicle Make</div>
                                </a>

                                <ul class="menu-sub">
                                    @canany(['list-vehicle_make', 'edit-vehicle_make', 'delete-vehicle_make'])
                                        <li class="menu-item {{ Route::is('admin.vehicle-make.index') ? 'active' : '' }}">
                                            <a href="{{ route('admin.vehicle-make.index') }}" class="menu-link">
                                                <div data-i18n="Without menu">List</div>
                                            </a>
                                        </li>
                                    @endcanany
                                    @can('add-vehicle_make')
                                        <li class="menu-item {{ Route::is('admin.vehicle-make.create') ? 'active' : '' }}">
                                            <a href="{{ route('admin.vehicle-make.create') }}" class="menu-link">
                                                <div data-i18n="Without navbar">Add</div>
                                            </a>
                                        </li>
                                    @endcan
                                </ul>
                            </li>
                        @endcanany
                        @canany(['add-vehicle_model', 'delete-vehicle_model', 'edit-vehicle_model', 'list-vehicle_model'])
                            <li class="menu-item {{ Route::is('admin.vehicle-model.*') ? 'open active' : '' }}">
                                <a href="javascript:void(0);" class="menu-link menu-toggle">
                                    <i class="menu-icon tf-icons fas fa-tools"></i>

                                    <div data-i18n="Layouts">Vehicle Model</div>
                                </a>

                                <ul class="menu-sub">
                                    @canany(['list-vehicle_model', 'edit-vehicle_model', 'delete-vehicle_model'])
                                        <li class="menu-item {{ Route::is('admin.vehicle-model.index') ? 'active' : '' }}">
                                            <a href="{{ route('admin.vehicle-model.index') }}" class="menu-link">
                                                <div data-i18n="Without menu">List</div>
                                            </a>
                                        </li>
                                    @endcanany
                                    @can('add-vehicle_model')
                                        <li class="menu-item {{ Route::is('admin.vehicle-model.create') ? 'active' : '' }}">
                                            <a href="{{ route('admin.vehicle-model.create') }}" class="menu-link">
                                                <div data-i18n="Without navbar">Add</div>
                                            </a>
                                        </li>
                                    @endcan
                                </ul>
                            </li>
                        @endcanany
                    @endcanany
                    <!-- Layouts -->
                    @canany(['add-product', 'delete-product', 'edit-product', 'list-product'])
                        <li class="menu-header small text-uppercase">
                            <span class="menu-header-text">Product Management</span>
                        </li>
                        <li class="menu-item {{ Route::is('admin.product.*') ? 'open active' : '' }}">
                            <a href="javascript:void(0);" class="menu-link menu-toggle">
                                <i class="menu-icon tf-icons fas fa-sitemap"></i>

                                <div data-i18n="Product">Product</div>
                            </a>

                            <ul class="menu-sub">
                                @canany(['list-product', 'edit-product', 'delete-product'])
                                    <li class="menu-item {{ Route::is('admin.product.index') ? 'active' : '' }}">
                                        <a href="{{ route('admin.product.index') }}" class="menu-link ">
                                            <div data-i18n="List">List</div>
                                        </a>
                                    </li>
                                @endcanany
                                @can('add-product')
                                    <li class="menu-item {{ Route::is('admin.product.create') ? 'active' : '' }}">
                                        <a href="{{ route('admin.product.create') }}" class="menu-link ">
                                            <div data-i18n="Add">Add</div>
                                        </a>
                                    </li>
                                @endcan



                            </ul>

                        </li>
                        {{-- review manage  --}}
                        <li class="menu-item {{ Route::is('admin.product.review') ? 'active' : '' }}">
                            <a href="{{ Route('admin.product.review') }}" class="menu-link ">
                                <i class="menu-icon tf-icons fas fa-comment"></i>

                                <div data-i18n="Product">Review</div>
                            </a>
                        </li>

                    @endcanany
                    @canany(['delete-customer', 'edit-customer', 'list-customer'])
                        <li class="menu-header small text-uppercase">
                            <span class="menu-header-text">Customer Management</span>
                        </li>
                        <li class="menu-item {{ Route::is('admin.customer.*') ? 'active' : '' }}">
                            <a href="{{ route('admin.customer.index') }}" class="menu-link ">
                                <i class="menu-icon tf-icons fas fa-users"></i>
                                {{-- <i class="menu-icon tf-icons bx bx-layout"></i> --}}
                                <div data-i18n="Layouts">Customer List</div>
                            </a>


                        </li>
                    @endcanany
                    @canany(['delete-wholesale_plan', 'edit-wholesale_plan', 'list-wholesale_plan',
                        'add-wholesale_plan'])
                        <li class="menu-header small text-uppercase">
                            <span class="menu-header-text">Wholesale Plan</span>
                        </li>
                        <li class="menu-item {{ Route::is('admin.wholesale-plan.*') ? 'open active' : '' }}">
                            <a href="javascript:void(0);" class="menu-link menu-toggle">
                                <i class="menu-icon tf-icons fas fa-id-card"></i>

                                <div data-i18n="Wholesale Plan">Wholesale Plan</div>
                            </a>

                            <ul class="menu-sub">
                                @canany(['delete-wholesale_plan', 'edit-wholesale_plan', 'list-wholesale_plan'])
                                    <li class="menu-item {{ Route::is('admin.wholesale-plan.index') ? 'active' : '' }}">
                                        <a href="{{ route('admin.wholesale-plan.index') }}" class="menu-link ">
                                            <div data-i18n="List">List</div>
                                        </a>
                                    </li>
                                @endcanany
                                @can('add-wholesale_plan')
                                    <li class="menu-item {{ Route::is('admin.wholesale-plan.create') ? 'active' : '' }}">
                                        <a href="{{ route('admin.wholesale-plan.create') }}" class="menu-link ">
                                            <div data-i18n="Add">Add</div>
                                        </a>
                                    </li>
                                @endcan

                            </ul>

                        </li>
                    @endcanany
                    @canany(['list-order', 'view-order-detail-order', 'status-update-order'])
                        <li class="menu-header small text-uppercase">
                            <span class="menu-header-text">Order Management</span>
                        </li>
                        <li class="menu-item {{ Route::is('admin.orders.*') ? 'active' : '' }}">
                            <a href="{{ route('admin.orders.index') }}" class="menu-link ">
                                <i class="menu-icon tf-icons fas fa-box"></i>
                                {{-- <i class="menu-icon tf-icons bx bx-layout"></i> --}}
                                <div data-i18n="Layouts">Orders</div>
                            </a>


                        </li>
                    @endcanany
                    @canany(['add-department', 'list-department', 'edit-department', 'delete-department',
                        'add-employee', 'list-employee', 'edit-employee', 'delete-employee'])
                        <li class="menu-header small text-uppercase">
                            <span class="menu-header-text">Roles Management</span>
                        </li>
                        @canany(['add-department', 'list-department', 'edit-department', 'delete-department'])
                            <li class="menu-item {{ Route::is('admin.department.*') ? 'open active' : '' }}">
                                <a href="javascript:void(0);" class="menu-link menu-toggle">
                                    <i class="menu-icon tf-icons fas fa-building"></i>

                                    <div data-i18n="Wholesale ID">Department</div>
                                </a>

                                <ul class="menu-sub">
                                    @canany(['list-department', 'edit-department', 'delete-department'])
                                        <li class="menu-item {{ Route::is('admin.department.index') ? 'active' : '' }}">
                                            <a href="{{ route('admin.department.index') }}" class="menu-link ">
                                                <div data-i18n="List">List</div>
                                            </a>
                                        </li>
                                    @endcanany
                                    @can('add-department')
                                        <li class="menu-item {{ Route::is('admin.department.create') ? 'active' : '' }}">
                                            <a href="{{ route('admin.department.create') }}" class="menu-link ">
                                                <div data-i18n="Add">Add</div>
                                            </a>
                                        </li>
                                    @endcan

                                </ul>

                            </li>
                        @endcanany
                        @role('Super Admin')
                            <li class="menu-item {{ Route::is('admin.role.*') ? 'open active' : '' }}">
                                <a href="javascript:void(0);" class="menu-link menu-toggle">
                                    <i class="menu-icon tf-icons fas fa-user-shield"></i>

                                    <div data-i18n="Wholesale ID">Role</div>
                                </a>

                                <ul class="menu-sub">
                                    <li class="menu-item {{ Route::is('admin.role.index') ? 'active' : '' }}">
                                        <a href="{{ route('admin.role.index') }}" class="menu-link ">
                                            <div data-i18n="List">List</div>
                                        </a>
                                    </li>
                                    <li class="menu-item {{ Route::is('admin.role.create') ? 'active' : '' }}">
                                        <a href="{{ route('admin.role.create') }}" class="menu-link ">
                                            <div data-i18n="Add">Add</div>
                                        </a>
                                    </li>


                                </ul>

                            </li>
                        @endrole
                        @canany(['add-employee', 'list-employee', 'edit-employee', 'delete-employee'])
                            <li class="menu-item {{ Route::is('admin.employee.*') ? 'open active' : '' }}">
                                <a href="javascript:void(0);" class="menu-link menu-toggle">
                                    <i class="menu-icon tf-icons fas fa-user-tie"></i>

                                    <div data-i18n="Wholesale ID">Employee</div>
                                </a>

                                <ul class="menu-sub">
                                    @canany(['list-employee', 'edit-employee', 'delete-employee'])
                                        <li class="menu-item {{ Route::is('admin.employee.index') ? 'active' : '' }}">
                                            <a href="{{ route('admin.employee.index') }}" class="menu-link ">
                                                <div data-i18n="List">List</div>
                                            </a>
                                        </li>
                                    @endcanany
                                    @canany(['add-employee'])
                                        <li class="menu-item {{ Route::is('admin.employee.create') ? 'active' : '' }}">
                                            <a href="{{ route('admin.employee.create') }}" class="menu-link ">
                                                <div data-i18n="Add">Add</div>
                                            </a>
                                        </li>
                                    @endcanany

                                </ul>
                                {{-- //pages --}}
                            <li class="menu-header small text-uppercase">
                                <span class="menu-header-text">Page Management</span>
                            </li>
                            <li class="menu-item {{ Route::is('admin.pages.*') ? 'open active' : '' }}">
                                <a href="javascript:void(0);" class="menu-link menu-toggle">
                                    <i class="menu-icon tf-icons fas fa-file-alt"></i>

                                    <div data-i18n="Product">Pages</div>
                                </a>

                                <ul class="menu-sub">

                                    <li class="menu-item {{ Route::is('admin.pages.aboutUs') ? 'active' : '' }}">
                                        <a href="{{ route('admin.pages.aboutUs') }}" class="menu-link ">
                                            <div data-i18n="about-us">About Us</div>
                                        </a>
                                    </li>
                                    <li class="menu-item {{ Route::is('admin.pages.privacyPolicy') ? 'active' : '' }}">
                                        <a href="{{ route('admin.pages.privacyPolicy') }}" class="menu-link ">
                                            <div data-i18n="about-us">Privacy Policy</div>
                                        </a>
                                    </li>
                                    <li class="menu-item {{ Route::is('admin.pages.termsConditions') ? 'active' : '' }}">
                                        <a href="{{ route('admin.pages.termsConditions') }}" class="menu-link ">
                                            <div data-i18n="about-us">Terms and Conditions</div>
                                        </a>
                                    </li>

                                </ul>

                            </li>

                            <li class="menu-header small text-uppercase">
                                <span class="menu-header-text">Banner Management</span>
                            </li>
                            <li class="menu-item {{ Route::is('admin.banner.*') ? 'open active' : '' }}">
                                <a href="javascript:void(0);" class="menu-link menu-toggle">
                                    <i class="menu-icon tf-icons fas fa-file-alt"></i>

                                    <div data-i18n="Product">Banner</div>
                                </a>

                                <ul class="menu-sub">

                                    <li class="menu-item {{ Route::is('admin.banner.create') ? 'active' : '' }}">
                                        <a href="{{ route('admin.banner.create') }}" class="menu-link ">
                                            <div data-i18n="about-us">Add</div>
                                        </a>
                                    </li>
                                    <li class="menu-item {{ Route::is('admin.banner.index') ? 'active' : '' }}">
                                        <a href="{{ route('admin.banner.index') }}" class="menu-link ">
                                            <div data-i18n="about-us">List</div>
                                        </a>
                                    </li>


                                </ul>

                            </li>

                            <li class="menu-header small text-uppercase">
                                <span class="menu-header-text">Support</span>
                            </li>
                            <li class="menu-item">
                                <a href="{{ route('admin.chat') }}" class="menu-link ">
                                    <i class="menu-icon tf-icons fas fa-comments"></i>
                                    <div data-i18n="Product">Live Chat</div>
                                </a>



                            </li>
                            </li>
                        @endcanany
                    @endcanany
                </ul>
            </aside>
            <!-- / Menu -->

            <!-- Layout container -->
            <div class="layout-page">
                <!-- Navbar -->

                <nav class="layout-navbar container-xxl navbar navbar-expand-xl navbar-detached align-items-center bg-navbar-theme"
                    id="layout-navbar">
                    <div class="layout-menu-toggle navbar-nav align-items-xl-center me-3 me-xl-0 d-xl-none">
                        <a class="nav-item nav-link px-0 me-xl-4" href="javascript:void(0)">
                            <i class="bx bx-menu bx-sm"></i>
                        </a>
                    </div>

                    <div class="navbar-nav-right d-flex align-items-center" id="navbar-collapse">
                        <!-- Search -->
                        <div class="navbar-nav align-items-center">
                            <div class="nav-item d-flex align-items-center">
                                <h6>Welcome <span class = "theme-text-color">
                                        {{ Auth::guard('admin')->user()->name }}</span>
                                    (Super Admin)
                                </h6>
                            </div>
                        </div>
                        <!-- /Search -->

                        <ul class="navbar-nav flex-row align-items-center ms-auto">
                            <!-- Place this tag where you want the button to render. -->
                            <li class="nav-item dropdown">
                                <a class="nav-link" href="javascript:void(0);" id="navbarNotifications"
                                    data-bs-toggle="dropdown">
                                    <i class="notification-bell fas fa-bell"></i>
                                    <span id="notification-badge"
                                        class="notification-count badge bg-danger rounded-pill">{{ $unreadCount }}</span>
                                </a>
                                <ul class="dropdown-menu dropdown-menu-end" aria-labelledby="navbarNotifications"
                                    style="width: 300px;">


                                    <li>
                                        <ul id="notification-list" class="list-unstyled px-2"
                                            style="max-height: 250px; overflow-y: auto;">
                                            @forelse ($notifications as $notification)
                                                <li
                                                    class="{{ $notification->is_read ? 'notification-read' : 'notification-unread' }}">
                                                    @if (isset($notification->data['url']))
                                                        <a class="notif-link"
                                                            href="{{ $notification->data['url'] }}">
                                                        @else
                                                            <a href="#">
                                                    @endif

                                                    <strong>{{ $notification->title }}</strong> -
                                                    {{ $notification->message }}
                                                    </a>
                                                </li>
                                                <li>
                                                    <div class="dropdown-divider"></div>
                                                </li>
                                            @empty
                                                <li id="no-notif">
                                                    No Notification
                                                </li>
                                            @endforelse
                                        </ul>
                                    </li>
                                </ul>
                            </li>

                            <!-- User -->
                            <li class="nav-item navbar-dropdown dropdown-user dropdown">
                                <a class="nav-link dropdown-toggle hide-arrow" href="javascript:void(0);"
                                    data-bs-toggle="dropdown">
                                    <div class="avatar ">
                                        <img src="{{ asset(Auth::guard('admin')->user()->image) }}" alt
                                            class=" rounded-circle profile_image" />
                                    </div>
                                </a>
                                <ul class="dropdown-menu dropdown-menu-end">
                                    <li>
                                        <a class="dropdown-item" href="#">
                                            <div class="d-flex">
                                                <div class="flex-shrink-0 me-3">
                                                    <div class="avatar ">
                                                        <img class="profile_image rounded-circle"
                                                            src="{{ asset(Auth::guard('admin')->user()->image) }}"
                                                            alt />
                                                    </div>
                                                </div>
                                                <div class="flex-grow-1">
                                                    <span
                                                        class="fw-semibold d-block">{{ Auth::guard('admin')->user()->name }}</span>
                                                    <small class="text-muted">Super Admin</small>
                                                </div>
                                            </div>
                                        </a>
                                    </li>
                                    <li>
                                        <div class="dropdown-divider"></div>
                                    </li>
                                    @can('profile-setting')
                                        <li>
                                            <a class="dropdown-item" href="{{ route('admin.profile') }}">
                                                <i class="bx bx-user me-2"></i>
                                                <span class="align-middle">My Profile</span>
                                            </a>
                                        </li>
                                        <li>
                                            <div class="dropdown-divider"></div>
                                        </li>
                                    @endcan
                                    @canany(['tax-setting', 'return-days-setting', 'currency-conversion-setting'])

                                        <li>
                                            <a class="dropdown-item" href="#">
                                                <i class="bx bx-cog me-2"></i>
                                                <span class="align-middle">Settings</span>
                                            </a>
                                            <ul class="setting-dp">
                                                @can('return-days-setting')
                                                    <li>
                                                        <a class="dropdown-item"
                                                            href="{{ route('admin.setting.returnDays') }}">
                                                            Return Days
                                                        </a>
                                                    </li>
                                                @endcan
                                                @can('currency-conversion-setting')
                                                    <li>
                                                        <a class="dropdown-item"
                                                            href="{{ route('admin.setting.currency') }}">
                                                            Currency Conversion
                                                        </a>
                                                    </li>
                                                @endcan
                                                @canany('tax-setting')
                                                    <li>
                                                        <a class="dropdown-item" href="{{ route('admin.setting.tax') }}">
                                                            Tax
                                                        </a>
                                                    </li>
                                                @endcan
                                            </ul>

                                        </li>
                                        <li>
                                            <div class="dropdown-divider"></div>
                                        </li>
                                    @endcanany
                                    {{-- <li>
                                        <a class="dropdown-item" href="#">
                                            <span class="d-flex align-items-center align-middle">
                                                <i class="flex-shrink-0 bx bx-credit-card me-2"></i>
                                                <span class="flex-grow-1 align-middle">Billing</span>
                                                <span
                                                    class="flex-shrink-0 badge badge-center rounded-pill bg-danger w-px-20 h-px-20">4</span>
                                            </span>
                                        </a>
                                    </li> --}}

                                    <li>
                                        <form id="logout-form" action="{{ route('admin.logout') }}" method="post"
                                            style="display:none;">
                                            @csrf
                                        </form>
                                        <a class="dropdown-item" href="#logout-form"
                                            onclick="event.preventDefault(); document.getElementById('logout-form').submit();">
                                            <i class="bx bx-power-off me-2"></i>
                                            <span class="align-middle">Log Out</span>
                                        </a>
                                    </li>
                                </ul>
                            </li>
                            <!--/ User -->
                        </ul>
                    </div>
                </nav>

                <!-- / Navbar -->

                <!-- Content wrapper -->
                <div class="content-wrapper">
                    @yield('content')
                    <!-- Footer -->
                    <footer class="content-footer footer bg-footer-theme">
                        <div
                            class="container-xxl d-flex flex-wrap justify-content-between py-2 flex-md-row flex-column">
                            <div class="mb-2 mb-md-0">
                                ©
                                <script>
                                    document.write(new Date().getFullYear());
                                </script>

                                <a href="https://www.intellisense.ca/" target="_blank"
                                    class="footer-link fw-bolder">Intellisense Technology</a>
                            </div>

                        </div>
                    </footer>
                    <!-- / Footer -->

                    <div class="content-backdrop fade"></div>
                </div>
                <!-- Content wrapper -->
            </div>
            <!-- / Layout page -->
        </div>

        <!-- Overlay -->
        <div class="layout-overlay layout-menu-toggle"></div>
    </div>
    <!-- / Layout wrapper -->



    <!-- Core JS -->
    <!-- build:js assets/vendor/js/core.js -->
    <script src="{{ asset('assets/vendor/libs/jquery/jquery.js') }}"></script>
    <script src="{{ asset('assets/vendor/libs/popper/popper.js') }}"></script>
    <script src="{{ asset('assets/vendor/js/bootstrap.js') }}"></script>
    <script src="{{ asset('assets/vendor/libs/perfect-scrollbar/perfect-scrollbar.js') }}"></script>

    <script src="{{ asset('assets/vendor/js/menu.js') }}"></script>
    <!-- endbuild -->

    <!-- Vendors JS -->
    <script src="{{ asset('assets/vendor/libs/apex-charts/apexcharts.js') }}"></script>

    <!-- Main JS -->
    <script src="{{ asset('assets/js/main.js') }}"></script>

    <!-- Page JS -->
    <script src="{{ asset('assets/js/dashboards-analytics.js') }}"></script>

    <!-- Place this tag in your head or just before your close body tag. -->
    @yield('scripts');
    <script async defer src="https://buttons.github.io/buttons.js"></script>
    <script src="https://cdn.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/js/select2.min.js"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/jquery-toast-plugin/1.3.2/jquery.toast.min.js"></script>
    <script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>
    <script src="https://cdn.datatables.net/2.2.2/js/dataTables.js"></script>
    <script src="https://cdn.datatables.net/responsive/3.0.4/js/dataTables.responsive.min.js"></script>
    <script src="//cdnjs.cloudflare.com/ajax/libs/ckeditor/4.22.1/ckeditor.js"></script>
    <script src="https://cdn.jsdelivr.net/npm/@fancyapps/ui@5.0/dist/fancybox/fancybox.umd.js"></script>
    <script src="https://cdn.jsdelivr.net/npm/flatpickr"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/intl-tel-input/17.0.19/js/intlTelInput.min.js"></script>
    <script src="https://js.pusher.com/8.2/pusher.min.js"></script>

    <!-- Laravel Echo -->
    {{-- <script src="https://cdn.jsdelivr.net/npm/laravel-echo@1.13.0/dist/echo.iife.js"></script> --}}

    <script>
        var APP_URL = {!! json_encode(url('/')) !!};
        const pusher = new Pusher("{{ env('PUSHER_APP_KEY') }}", {
            cluster: "{{ env('PUSHER_APP_CLUSTER') }}",
            forceTLS: true,
            channelAuthorization: {
                endpoint: "/broadcasting/auth",
                headers: {
                    "X-CSRF-TOKEN": document.querySelector('meta[name="csrf-token"]').getAttribute("content"),
                },
            },
        });

        var channel = pusher.subscribe("private-admin-notifications");

        channel.bind("new-admin-notification", function(data) {
            //console.log("Notification received:", data);
            // Example: append to list
            let html = `<li>
                    <a class="notif-link" href="${data.url}">
                   <strong> ${data.title}</strong>
                   - 
                ${data.message}
                </a>
                    </li>
                     <li>
                        <div class="dropdown-divider"></div>
                    </li>
                    `;
            $("#notification-list").prepend(html);
            $("#no-notif").remove();
            //remove last 5 notification from actual ui
            $items = $("#notification-list li");
            if ($items.length > 10) {
                $items.slice(10).remove();
            }
            // Update badge
            let badge = $("#notification-badge");
            let count = parseInt(badge.text()) + 1;
            badge.text(count);
        });
        let activeConversationId = null;
        var chatChannel = pusher.subscribe("private-chat." + convo_id);

        chatChannel.bind("new-chat-message", function(data) {
            //console.log('received message data', data);
            if (parseInt(data.conversation_id) === parseInt(activeConversationId)) {
                appendMessageToUI(data);
            }

        });

        function loadMessages(conversationId) {
            fetch(`/admin/chat/${conversationId}/messages`)
                .then(res => res.json())
                .then(messages => {
                    let messagesHtml = '';
                    messages.forEach(msg => {
                        if (msg.sender_type === "App\\Models\\Customer") {
                            messagesHtml += `
                        <li class="d-flex mb-4 customer-message">
                            <img src="${msg.sender?.avatar_url}" width="50" height="50" class="rounded-circle me-2">
                            <div class="card">
                                <div class="card-header p-2"><strong>${msg.sender?.full_name ?? 'Customer'}</strong></div>
                                <div class="card-body"><p>${msg.message}</p></div>
                            </div>
                        </li>`;
                        } else {
                            messagesHtml += `
                        <li class="d-flex mb-4 admin-message">
                            <div class="card w-100">
                                <div class="card-header p-2"><strong>${msg.sender?.name ?? 'Admin'}</strong></div>
                                <div class="card-body"><p>${msg.message}</p></div>
                            </div>
                            <img src="${msg.sender?.avatar_url}" width="50" height="50" class="rounded-circle ms-2">
                        </li>`;
                        }
                    });
                    document.getElementById("messages-list").innerHTML = messagesHtml;
                });
        }

        // Attach once
        document.querySelectorAll(".conversation-item").forEach(item => {
            item.addEventListener("click", function() {
                activeConversationId = this.dataset.id;
                loadMessages(this.dataset.id);
            });
        });
        // Append message to UI
        function appendMessageToUI(msg) {
            let avatar = msg.sender?.avatar_url ?? '/uploads/default.png';
            let sender = msg.sender;
            let html = '';
            console.log(msg.sender);
            if (msg.sender_type === "Customer") {
                html += `
                        <li class="d-flex mb-4 customer-message">
                            <img src="${avatar}" width="50" height="50" class="rounded-circle me-2">
                            <div class="card">
                                <div class="card-header p-2"><strong>${sender.name ?? 'Customer'}</strong></div>
                                <div class="card-body"><p>${msg.message}</p></div>
                            </div>
                        </li>`;
            } else {
                html += `
                        <li class="d-flex mb-4 admin-message">
                            <div class="card w-100">
                                <div class="card-header p-2"><strong>${sender.name ?? 'Admin'}</strong></div>
                                <div class="card-body"><p>${msg.message}</p></div>
                            </div>
                            <img src="${avatar}" width="50" height="50" class="rounded-circle ms-2">
                        </li>`;
            }

            document.querySelector("#messages-list").insertAdjacentHTML("beforeend", html);
        }
        //send message
        document.querySelector('#send-btn').addEventListener('click', function() {
            let msg = document.querySelector('#message-input').value;
            if (!msg) return;
            fetch(`/admin/chat/${convo_id}/send`, {
                    method: "POST",
                    headers: {
                        "Content-Type": "application/json",
                        "X-CSRF-TOKEN": document.querySelector('meta[name="csrf-token"]').getAttribute(
                            "content")
                    },
                    body: JSON.stringify({
                        message: msg
                    })
                })
                .then(res => res.json())
                .then(data => {
                    if (data.success) {
                        appendMessageToUI(data.message); // instantly show
                        document.querySelector("#message-input").value = "";
                    }
                });
        });
    </script>
    <script src="{{ asset('assets/js/script.js') }}"></script>
</body>

</html>
