<table id="myTable" class="dataTable table table-hover display responsive nowrap">
    <thead>
        <tr>

            <th>
                <span class="sortable" data-sort="name" data-order="asc">
                    Name
                    <i id="sort-icon-name" class="bx bx-sort"></i>
                </span>
            </th>
            <th>

                Assigned Role


            </th>
            <th>

                Assigned Department


            </th>
            <th>
                <span class="sortable" data-sort="status" data-order="asc">
                    Status
                    <i id="sort-icon-status" class="bx bx-sort"></i>
                </span>
            </th>
            <th>
                <span class="sortable" data-sort="created_at" data-order="asc">
                    Created at
                    <i id="sort-icon-created_at" class="bx bx-sort"></i>
                </span>

            </th>
            <th>Actions</th>
        </tr>
    </thead>
    @if (isset($employees) && count($employees) > 0)
        <tbody class="table-border-bottom-0">

            @foreach ($employees as $employee)
                <tr>

                    <td class="text-capitalize">{{ $employee->name }}</td>
                    <td class="text-capitalize"> {{ $employee->roles->pluck('actual_name')->implode(', ') }}</td>
                    <td>{{ ucfirst($employee->roles->pluck('department.name')->filter()->implode(', ')) }}</td>


                    <td>
                        <span class="badge {{ badgesforStatuses($employee->status) }}">
                            {{ basicStatusesDisplay($employee->status) }}
                        </span>

                    </td>
                    <td>{{ dateInList($employee->created_at) }}</td>
                    {{-- <td><span class="badge bg-label-primary me-1">Active</span></td> --}}
                    <td class="{{ hideAction($employee->status) }}">
                        @canany(['list-employee', 'edit-employee', 'delete-employee'])
                            <div class="dropdown">
                                <button type="button" class="btn p-0 dropdown-toggle hide-arrow" data-bs-toggle="dropdown">
                                    <i class="bx bx-dots-vertical-rounded"></i>
                                </button>
                                <div class="dropdown-menu">
                                    @can('edit-employee')
                                        <a class="dropdown-item" href="{{ route('admin.employee.edit', $employee->id) }}"><i
                                                class="bx bx-edit-alt me-1"></i> Edit</a>
                                    @endcan
                                    @can('delete-employee')
                                        <button data-url="{{ route('admin.employee.destroy', $employee->id) }}"
                                            data-id="{{ $employee->id }}" type="button" class="dropdown-item delete-btn"
                                            href="javascript:void(0);"><i class="bx bx-trash me-1"></i>
                                            Delete</button>
                                    @endcan
                                </div>
                            </div>
                        @endcanany
                    </td>
                </tr>
            @endforeach
        </tbody>
        <tfoot>
            <tr>
                <td class="" colspan="6">
                    <div class="mt-2 row justify-space-between mb-2">
                        <div class="col-md-6">
                            <div class="" id="records">{!! pageInfo($employees) !!}</div>
                        </div>
                        <div class="col-md-6 pagination-end">

                            {!! $employees->links('pagination::bootstrap-4') !!}

                        </div>
                    </div>
                </td>
            </tr>
        </tfoot>

    @endif
</table>
