@extends('admin.layouts.app')
@section('title', 'Create Employee')
@section('content')
    <!-- Content -->

    <div class="container-xxl flex-grow-1 container-p-y">

        <div class="row">
            <!-- Basic Layout -->
            <div class="col-xxl-10 col-lg-10 col-md-12 col-sm-12">
                <div class="card px-4 mb-4">
                    <div class="title-n-btn">
                        <h4 class="">Create Employee</h4>

                    </div>

                    <div class="card-body px-0">
                        <form class="ajax-submit-form" data-url="{{ route('admin.employee.store') }}" data-method="POST"
                            enctype="multipart/form-data">

                            <div class="row mb-3">
                                <label class="col-sm-2 col-form-label" for="name">Assign Role</label>
                                <div class="col-sm-10">
                                    <select name="role" id="role" class="form-select">

                                        @foreach ($roles as $role)
                                            <option value="{{ $role->name }}">{{ ucfirst($role->name) }}
                                            </option>
                                        @endforeach
                                    </select>
                                </div>
                            </div>
                            {{-- Name --}}
                            <div class="row mb-3">
                                <label class="col-sm-2 col-form-label" for="name">Name</label>
                                <div class="col-sm-10">
                                    <input name="name" type="text" class="form-control" id="name" />
                                </div>
                            </div>



                            {{-- Email --}}
                            <div class="row mb-3">
                                <label class="col-sm-2 col-form-label" for="email">Email</label>
                                <div class="col-sm-10">
                                    <input name="email" type="email" class="form-control" id="email" />
                                </div>
                            </div>

                            {{-- Mobile Number --}}
                            <div class="row mb-3">
                                <label class="col-sm-2 col-form-label" for="mobile_number">Mobile Number</label>
                                <div class="col-sm-10">
                                    <input name="mobile_number" type="text" class="form-control" id="mobile_number" />
                                </div>
                            </div>

                            {{-- DOB --}}
                            <div class="row mb-3">
                                <label class="col-sm-2 col-form-label" for="dob">DOB</label>
                                <div class="col-sm-10">
                                    <input name="dob" type="date" class="form-control" id="dob" />
                                </div>
                            </div>

                            {{-- Gender --}}
                            <div class="row mb-3">
                                <label class="col-sm-2 col-form-label" for="gender">Gender</label>
                                <div class="col-sm-10">
                                    <select class="form-select" name="gender" id="gender">
                                        <option value="">Select</option>
                                        <option value="male">Male</option>
                                        <option value="female">Female</option>
                                        <option value="other">Other</option>
                                    </select>
                                </div>
                            </div>

                            {{-- Address --}}
                            <div class="row mb-3">
                                <label class="col-sm-2 col-form-label" for="address">Address</label>
                                <div class="col-sm-10">
                                    <textarea name="address" class="form-control" id="address" rows="2"></textarea>
                                </div>
                            </div>

                            {{-- Image --}}
                            <div class="row mb-3">
                                <label class="col-sm-2 col-form-label" for="image">Image</label>
                                <div class="col-sm-10">
                                    <input type="file" name="image" class="form-control" id="image">
                                </div>
                            </div>

                            {{-- Password --}}
                            <div class="row mb-3">
                                <label class="col-sm-2 col-form-label" for="password">Password</label>
                                <div class="col-sm-10">
                                    <input name="password" type="password" class="form-control" id="password" />
                                </div>
                            </div>

                            {{-- Confirm Password --}}
                            <div class="row mb-3">
                                <label class="col-sm-2 col-form-label" for="password_confirmation">Confirm Password</label>
                                <div class="col-sm-10">
                                    <input name="password_confirmation" type="password" class="form-control"
                                        id="password_confirmation" />
                                </div>
                            </div>

                            {{-- Status --}}
                            <div class="row mb-3">
                                <label class="col-sm-2 col-form-label" for="status">Status</label>
                                <div class="col-sm-10">
                                    <select class="form-select" name="status" id="status">
                                        @foreach (CommonStatusesForCrud() as $key => $value)
                                            <option value="{{ $key }}">{{ $value }}</option>
                                        @endforeach
                                    </select>
                                </div>
                            </div>

                            {{-- Submit --}}
                            <div class="row justify-content-end">
                                <div class="col-sm-10">
                                    <button type="submit" class="btn btn-primary">Create</button>
                                </div>
                            </div>
                        </form>
                    </div>
                </div>
            </div>

        </div>
    </div>

    <!-- / Content -->
@endsection
@section('scripts')
    <script>
        flatpickr("#dob", {
            maxDate: new Date().fp_incr(-18 * 365),
            minDate: new Date().fp_incr(-70 * 365),
            dateFormat: "d-m-Y",
        });
    </script>

@endsection
