@extends('admin.layouts.app')
@section('title', 'Edit Banner')
@section('content')
    <div class="content-wrapper">
        <!-- Content -->
        <div class="container">


            <div class="row mt-4">
                <div class="col-lg-12">
                    <div class="card">
                        <h5 class="card-header text-uppercase text-dark border-bottom">
                            Edit Banner
                        </h5>

                        <div class="card-body">
                            @if ($errors->any())
                                <div class="alert alert-danger">
                                    <ul>
                                        @foreach ($errors->all() as $error)
                                            <li>{{ $error }}</li>
                                        @endforeach
                                    </ul>
                                </div>
                            @endif
                            <div class="row mt-4">
                                <div class="col-lg-12">
                                    <form class="ajax-submit-form"
                                        data-url="{{ route('admin.banner.update', $banner->id) }}" data-method="POST"
                                        enctype="multipart/form-data">
                                        @method('PUT')

                                        <div class="row mb-3 justify-content-end ">


                                            <div class="col-12">
                                                <div class="row my-3">
                                                    <label for="image" class="col-md-2 text-sm-end col-form-label">
                                                        Image / Video
                                                    </label>
                                                    <div class="col-md-10">
                                                        <input type="file" class="form-control " name="file"
                                                            id="file">

                                                        <div class="old-file mt-3">
                                                            @php
                                                                $thumb = null;
                                                                if ($banner->media_type == IMAGE) {
                                                                    $thumb = $banner->media_path;
                                                                } elseif ($banner->media_type == VIDEO) {
                                                                    $thumb = $banner->video_poster;
                                                                }
                                                            @endphp
                                                            @if ($thumb)
                                                                <img src="{{ asset($thumb) }}" alt="Banner Thumbnail"
                                                                    width="100px">
                                                            @else
                                                                <span class="text-muted">No media</span>
                                                            @endif
                                                        </div>
                                                    </div>

                                                </div>

                                                <div class="row my-3">
                                                    <label for="status"
                                                        class="col-md-2 text-sm-end col-form-label">Status</label>
                                                    <div class="col-md-10">
                                                        <select class="form-select" name="status" id="status">
                                                            @foreach (CommonStatusesForCrud() as $key => $value)
                                                                <option value="{{ $key }}"
                                                                    {{ $key == old('status', $banner->status) ? 'selected' : '' }}>
                                                                    {{ $value }}
                                                                </option>
                                                            @endforeach

                                                        </select>
                                                        <input type="hidden" name="video_poster" id="video_poster"
                                                            class="video_poster">
                                                    </div>
                                                </div>

                                                {{-- sort order --}}
                                                <div class="row my-3">
                                                    <label for="image" class="col-md-2 text-sm-end col-form-label">
                                                        Sort Order
                                                    </label>
                                                    <div class="col-md-10">
                                                        <select class="form-select" name="sort_order" id="sort_order">
                                                            @for ($i = 1; $i <= $maxSortCount; $i++)
                                                                @php
                                                                    $isUsed = in_array($i, $usedSortOrders);
                                                                    $isSelected = $banner->sort_order == $i;
                                                                @endphp
                                                                <option value="{{ $i }}"
                                                                    {{ $isSelected ? 'selected' : '' }}>
                                                                    {{ $i }}
                                                                    {{ $isUsed && !$isSelected ? '(used)' : '' }}
                                                                </option>
                                                            @endfor
                                                        </select>

                                                    </div>
                                                </div>

                                            </div>
                                        </div>


                                        <div class=" offset-md-2">
                                            <button type="submit" class="btn btn-primary">
                                                <i class="bx bx-check"></i> Update
                                            </button>
                                        </div>
                                </div>

                                </form>

                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <!-- / Content -->
        </div>
    @endsection
    @section('scripts')
        <script>
            document.addEventListener("DOMContentLoaded", function() {
                const fileInput = document.getElementById("file"); // your input[type=file]
                const video = document.createElement("video");
                video.style.display = "none";
                document.body.appendChild(video);

                const hiddenPosterInput = document.getElementById("video_poster");

                fileInput.addEventListener("change", function() {
                    const file = fileInput.files[0];
                    if (!file) return;

                    const fileExtension = file.name.split('.').pop().toLowerCase();
                    const videoExtensions = ['mp4', 'webm', 'ogg'];

                    if (videoExtensions.includes(fileExtension)) {
                        const videoURL = URL.createObjectURL(file);
                        video.src = videoURL;

                        video.onloadeddata = () => {
                            video.currentTime = 1;
                        };

                        video.onseeked = () => {
                            const canvas = document.createElement("canvas");
                            canvas.width = video.videoWidth;
                            canvas.height = video.videoHeight;

                            const ctx = canvas.getContext("2d");
                            ctx.drawImage(video, 0, 0, canvas.width, canvas.height);

                            const base64Image = canvas.toDataURL("image/jpeg", 0.8); // 80% quality
                            hiddenPosterInput.value = base64Image;
                        };
                    } else {
                        hiddenPosterInput.value = ''; // Clear if not video
                    }
                });
            });
        </script>
    @endsection
