<?php

namespace Database\Seeders;

use Illuminate\Database\Console\Seeds\WithoutModelEvents;
use Illuminate\Database\Seeder;
use App\Models\Order;
use App\Models\OrderDetail;
use App\Models\Product;
use App\Models\shipping_address;
use App\Models\ShippingAddress;
use App\Models\Transaction;
use Faker\Factory as Faker;

class OrderSeeder extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        $faker = Faker::create();
        $products = Product::all();

        foreach (range(1, 100) as $i) {
            $customerId = rand(1, 50);
            $shippingAddress = shipping_address::where('customer_id', $customerId)->inRandomOrder()->first();

            $conversionRate = rand(0, 1) ? 1800 : 2000;
            $orderNumber = strtoupper('ORD' . uniqid());

            $totalItems = 0;
            $totalUsd = 0;
            $totalMmk = 0;
            $statusMap = [
                'pending' => 0,
                'confirmed' => 1,
                'shipped' => 2,
                'delivered' => 3,
            ];

            $statusKey = $faker->randomElement(array_keys($statusMap));
            // Create Order
            $order = Order::create([
                'customer_id' => $customerId,
                'shipping_address_id' => $shippingAddress->id,
                'order_number' => $orderNumber,
                'order_status' => $statusMap[$statusKey],
                'total_price_usd' => 0, // to update later
                'total_price_mmk' => 0,
                'conversion_rate' => $conversionRate,
                'total_items' => 0,
            ]);

            $selectedProducts = $products->random(rand(1, 4));

            foreach ($selectedProducts as $product) {
                $qty = rand(1, 3);
                $priceUsd = $product->price_in_usd;
                $priceMmk = $priceUsd * $conversionRate;
                $total = $priceUsd * $qty;
                $totalUsd += $total;
                $totalMmk += $total * $conversionRate;
                $totalItems += $qty;

                OrderDetail::create([
                    'order_id' => $order->id,
                    'product_id' => $product->id,
                    'product_name' => $product->name,
                    'price_usd' => $priceUsd,
                    'price_mmk' => $priceUsd * $conversionRate,
                    'conversion_rate' => $conversionRate,
                    'quantity' => $qty,
                    'total' => $total,
                ]);
            }

            $order->update([
                'total_price_usd' => $totalUsd,
                'total_price_mmk' => $totalMmk,
                'total_items' => $totalItems,
            ]);

            // Create Transaction
            Transaction::create([
                'order_id' => $order->id,
                'payment_status' => $faker->randomElement(['pending', 'failed', 'complete']),
                'payment_method' => $faker->randomElement(['credit_card', 'cash', 'wallet']),
                'transaction_id' => strtoupper('TXN' . uniqid()),
                'amount' => $totalUsd,
                'txn_datentime' => $faker->dateTimeBetween('-30 days', 'now'),
            ]);
        }
    }
}
