<?php

namespace App\Providers;

use App\Helpers\CommonHelper;
use App\Models\Notification;
use Illuminate\Support\Facades\Blade;
use Illuminate\Support\Facades\View;
use Illuminate\Support\ServiceProvider;

class AppServiceProvider extends ServiceProvider
{
    /**
     * Register any application services.
     *
     * @return void
     */
    public function register()
    {
        //
    }

    /**
     * Bootstrap any application services.
     *
     * @return void
     */
    public function boot()
    {
        Blade::if('canViewOrderDetail', function ($order) {
            return CommonHelper::canViewOrderDetail(auth()->user(), $order);
        });

        // Share notifications with the main layout
        View::composer('*', function ($view) {
            $unreadCount = Notification::where('receiver_type', 'ADMIN')
                ->where('is_read', 0)
                ->count();
            $notifications = Notification::where('receiver_type', 'ADMIN')
                ->orderBy('created_at', 'desc')
                ->take(5)
                ->get();
            //json decode
            $notifications->transform(function ($notification) {
                $notification->data = json_decode($notification->data, true);
                return $notification;
            });
            $view->with(compact('unreadCount', 'notifications'));
        });
    }
}
