<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class VehicleType extends Model
{
    use SoftDeletes;
    use HasFactory;
    protected $fillable = [
        'name',
        'status',
    ];
    public function vehicleModels()
    {
        return $this->hasMany(VehicleModel::class);
    }

    // Automatically handle cascade detach & deletes
    protected static function booted()
    {
        static::deleting(function ($vehicleType) {
            // Detach all related makes from pivot table
            $vehicleType->makes()->detach();

            // Delete all related vehicle models
            $vehicleType->vehicleModels->each(function ($model) {
                $model->status = 2;
                $model->save();
                $model->delete();
            });
        });
    }
    public function makes()
    {
        return $this->belongsToMany(VehicleMake::class, 'vehicle_make_vehicle_type');
    }
    public function getPaginatedData($request)
    {
        $query = self::withTrashed()->whereIn('status', [0, 1]);

        $perPage = $request->input('per_page', 10);
        $sortBy = $request->get('sort_by');
        $allowedSortColumns = ['id', 'name', 'status', 'created_at']; // add only valid DB columns here

        // Default to 'vehicle_types.id' if invalid or empty
        $sortBy = in_array($sortBy, $allowedSortColumns) ? 'vehicle_types.' . $sortBy : 'vehicle_types.id';

        $sortOrder = $request->get('sort_order', 'desc');
        $sortOrder = in_array(strtolower($sortOrder), ['asc', 'desc']) ? $sortOrder : 'desc';

        if ($request->filled('keyword')) {
            $keyword = $request->keyword;
            $query->where(function ($q) use ($keyword) {
                $q->where('name', 'like', "%$keyword%")
                    ->orWhere('status', 'like', "%$keyword%")
                    ->orWhere('id', 'like', "%$keyword%");
            });
        }

        if ($request->filled('status')) {
            $query->where('status', $request->status);
        }

        return $query->orderBy($sortBy, $sortOrder)->paginate($perPage);
    }
}
