<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class ProductStock extends Model
{
    use HasFactory;
    protected $fillable = [
        'order_id',
        'product_id',
        'type',
        'quantity',
        'comment',
    ];
    public function product()
    {
        return $this->belongsTo(Product::class);
    }
    //claculate in hand stock
    public static function calculateInHandStock($productId)
    {
        $in = self::where('product_id', $productId)->where('type', 'in')->sum('quantity');
        $out = self::where('product_id', $productId)->where('type', 'out')->sum('quantity');
        return max(0, ($in - $out));
    }
}
