<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Support\Facades\Validator;

class CustomerAddress extends Model
{
    use HasFactory;
    protected $table = 'customers_addresses';
    protected $fillable = [
        'customer_id',
        'type',
        'address',
        'city',
        'state',
        'country',
        'pincode',
        'is_default'
    ];

    public function customer()
    {
        return $this->belongsTo(Customer::class);
    }
    //validation
    public  static function addressValidation($requests = [], $type = 'store')
    {
        $rules = [
            'address_line1' => 'required|string|max:500',
            'country_id' => 'required|integer|exists:countries,id',
            'state_id' => 'required|integer|exists:states,id',
            'city_id' => 'required|integer|exists:cities,id',
            'pincode' => 'required|string|max:20',
            'is_default' => 'boolean'
        ];
        if ($type == 'update') {
            $rules['address_id'] = 'required|integer|exists:customers_addresses,id';
        }
        return Validator($requests, $rules);
    }
}
