<?php

namespace App\Http\Controllers\Api;

use App\Helpers\CommonHelper;
use App\Http\Controllers\Controller;
use App\Models\ContactUs;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Validator;
use Throwable;

class SupportController extends Controller
{
    public function contactUs(Request $request)
    {
        $validation =   Validator::make($request->all(), [
            'name' => 'required|min:3|max:50|regex:/^[a-zA-Z\s]+$/',
            'email' => 'required|email',
            'message' => 'required|string'
        ]);
        if ($validation->fails()) {
            return CommonHelper::apiResponse(400, $validation->errors()); // return validation errors
        }
        try {
            ContactUs::create($request->only('name', 'email', 'message'));
            return CommonHelper::apiResponse(200, __("Contact us successfully"), [], __("Contact us message description"));
        } catch (Throwable $e) {
            return CommonHelper::apiErrorResponse($e);
        }
    }
    //get pages links
    public function getPagesLinks(Request $request)
    {
        $validation = validator::make($request->all(), [
            'lang' => 'required'
        ]);
        if ($validation->fails()) {
            return CommonHelper::apiResponse(400, $validation->errors()); // return validation errors
        }
        $lang = $request->lang;
        $data = [
            'privacy_policy' => route('privacyPolicy', $lang),
            'terms_conditions' => route('termsConditions', $lang),
            'about_us' => route('aboutUs', $lang),
        ];

        return CommonHelper::apiResponse(200, '', $data);
    }
}
