<?php

namespace App\Http\Controllers\Api;

use App\Helpers\CommonHelper;
use App\Http\Controllers\Controller;
use App\Models\Conversation;
use Illuminate\Http\Request;

class ConversationController extends Controller
{
    //start a new conversation
    public function store(Request $request)
    {
        //firstOrcreate will create conversaton if no one conversation is open
        $conversation =  Conversation::firstOrCreate([
            'customer_id' => auth()->id(),
            'status' => 'open',
            'assigned_to' => (int) 1
        ]);
        $data = [
            'conversation_id' => $conversation->id,
            'status' => $conversation->status
        ];
        return CommonHelper::apiResponse(200, __('conversation_started'), $data);
    }
    //list all conversation
    /*public function index()
    {
        $conversations = Conversation::where('customer_id', auth()->id())
            ->with(['lastMessage'])
            ->latest()
            ->get()->map(function ($conversation) {
                return [
                    'status' => $conversation->status,
                    'start_at' => $conversation->created_at,
                    'last_message' => $conversation->lastMessage->message,
                ];
            });

        return CommonHelper::apiResponse(200, __('conversation_retrieved'),  $conversations);
    }*/
}
